/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.http2client.impl;

import com.webpieces.hpack.api.dto.Http2Headers;
import com.webpieces.http2engine.api.client.Http2ResponseListener;
import com.webpieces.http2engine.api.client.PushPromiseListener;
import com.webpieces.http2parser.api.dto.DataFrame;
import com.webpieces.http2parser.api.dto.RstStreamFrame;
import com.webpieces.http2parser.api.dto.lib.PartialStream;
import java.util.concurrent.CompletableFuture;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;
import org.webpieces.data.api.DataWrapperGeneratorFactory;
import org.webpieces.http2client.api.dto.Http2Response;
import org.webpieces.http2client.api.exception.ServerRstStreamException;

public class SingleResponseListener
implements Http2ResponseListener {
    private static final DataWrapperGenerator dataGen = DataWrapperGeneratorFactory.createDataWrapperGenerator();
    private CompletableFuture<Http2Response> responseFuture = new CompletableFuture();
    private Http2Headers headers;
    private DataWrapper fullData = dataGen.emptyWrapper();

    public CompletableFuture<Void> incomingPartialResponse(PartialStream response) {
        if (this.headers == null) {
            this.incomingResponse((Http2Headers)response);
        } else if (response instanceof DataFrame) {
            this.incomingData((DataFrame)response);
        } else if (response instanceof RstStreamFrame) {
            this.serverCancelledRequest((RstStreamFrame)response);
        } else if (response instanceof Http2Headers) {
            this.incomingEndHeaders((Http2Headers)response);
        } else {
            throw new UnsupportedOperationException("missing use case. type=" + response.getClass() + " msg=" + response);
        }
        return CompletableFuture.completedFuture(null);
    }

    public void incomingResponse(Http2Headers headers) {
        this.headers = headers;
        if (headers.isEndOfStream()) {
            this.responseFuture.complete(new Http2Response(headers, this.fullData, null));
        }
    }

    public void incomingData(DataFrame data) {
        this.fullData = dataGen.chainDataWrappers(this.fullData, data.getData());
        if (data.isEndOfStream()) {
            this.responseFuture.complete(new Http2Response(this.headers, this.fullData, null));
        }
    }

    public void incomingEndHeaders(Http2Headers trailingHeaders) {
        if (!trailingHeaders.isEndOfStream()) {
            this.responseFuture.completeExceptionally(new IllegalArgumentException("An assumption we made was wrong.  isComplete should be true here"));
            throw new IllegalArgumentException("An assumption we made was wrong.  isComplete should be true here");
        }
        Http2Response response = new Http2Response(this.headers, this.fullData, trailingHeaders);
        this.responseFuture.complete(response);
    }

    public void serverCancelledRequest(RstStreamFrame response) {
        this.responseFuture.completeExceptionally(new ServerRstStreamException("Server cancelled this stream. code=" + response.getErrorCode()));
    }

    public CompletableFuture<Http2Response> fetchResponseFuture() {
        return this.responseFuture;
    }

    public PushPromiseListener newIncomingPush(int streamId) {
        throw new UnsupportedOperationException("you should either turn push promise setting off or not use single request/response since the server is sending a push_promise");
    }
}

