/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.http2client.impl;

import com.webpieces.http2engine.api.client.ClientEngineListener;
import com.webpieces.http2parser.api.Http2Exception;
import com.webpieces.http2parser.api.dto.lib.Http2Frame;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.webpieces.http2client.api.Http2ServerListener;
import org.webpieces.http2client.api.Http2Socket;
import org.webpieces.http2client.impl.Layer1Incoming;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.channels.TCPChannel;
import org.webpieces.nio.api.handlers.DataListener;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class Layer3Outgoing
implements ClientEngineListener {
    private static final Logger log = LoggerFactory.getLogger(Layer3Outgoing.class);
    private TCPChannel channel;
    private Http2ServerListener clientListener;
    private Http2Socket socket;

    public Layer3Outgoing(TCPChannel channel, Http2Socket socket) {
        this.channel = channel;
        this.socket = socket;
    }

    public CompletableFuture<Void> sendToSocket(ByteBuffer data) {
        log.info("writing out data to socket size=" + data.remaining());
        return this.channel.write(data).thenApply(c -> null);
    }

    public void setClientListener(Http2ServerListener listener) {
        this.clientListener = listener;
    }

    public Http2ServerListener getClientListener() {
        return this.clientListener;
    }

    public void sendPreface(ByteBuffer buf) {
        this.channel.write(buf);
    }

    public CompletableFuture<Channel> connect(InetSocketAddress addr, Layer1Incoming incoming) {
        return this.channel.connect((SocketAddress)addr, (DataListener)incoming);
    }

    public CompletableFuture<Channel> close() {
        return this.channel.close();
    }

    public void sendControlFrameToClient(Http2Frame lowLevelFrame) {
        this.clientListener.incomingControlFrame(lowLevelFrame);
    }

    public void engineClosedByFarEnd() {
        this.clientListener.farEndClosed(this.socket);
    }

    public void closeSocket(Http2Exception reason) {
        this.channel.close();
        this.clientListener.socketClosed(this.socket, reason);
    }
}

