/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.http2client.impl;

import com.webpieces.hpack.api.dto.Http2Request;
import com.webpieces.hpack.api.dto.Http2Trailers;
import com.webpieces.http2engine.api.ResponseHandler;
import com.webpieces.http2engine.api.StreamHandle;
import com.webpieces.http2engine.api.StreamWriter;
import com.webpieces.http2engine.api.client.ClientEngineListener;
import com.webpieces.http2engine.api.client.Http2ClientEngine;
import com.webpieces.http2engine.api.client.Http2ClientEngineFactory;
import com.webpieces.http2parser.api.dto.DataFrame;
import com.webpieces.http2parser.api.dto.lib.StreamMsg;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.http2client.api.Http2Socket;
import org.webpieces.http2client.api.dto.FullRequest;
import org.webpieces.http2client.api.dto.FullResponse;
import org.webpieces.http2client.impl.Layer1Incoming;
import org.webpieces.http2client.impl.Layer3Outgoing;
import org.webpieces.http2client.impl.SingleResponseListener;
import org.webpieces.nio.api.channels.TCPChannel;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class Http2SocketImpl
implements Http2Socket {
    private static final Logger log = LoggerFactory.getLogger(Http2SocketImpl.class);
    private Layer1Incoming incoming;
    private Layer3Outgoing outgoing;

    public Http2SocketImpl(TCPChannel channel, Http2ClientEngineFactory factory) {
        this.outgoing = new Layer3Outgoing(channel, this);
        Http2ClientEngine parseLayer = factory.createClientParser("" + channel, (ClientEngineListener)this.outgoing);
        this.incoming = new Layer1Incoming(parseLayer);
    }

    @Override
    public CompletableFuture<Void> connect(InetSocketAddress addr) {
        if (addr == null) {
            throw new IllegalArgumentException("addr cannot be null");
        }
        return ((CompletableFuture)this.outgoing.connect(addr, this.incoming).thenCompose(c -> this.incoming.sendInitialFrames())).thenApply(f -> {
            log.info("connecting complete as initial frames sent");
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.outgoing.close();
    }

    @Override
    public CompletableFuture<FullResponse> send(FullRequest request) {
        SingleResponseListener responseListener = new SingleResponseListener();
        StreamHandle streamHandle = this.openStream();
        Http2Request req = request.getHeaders();
        if (request.getPayload() == null) {
            request.getHeaders().setEndOfStream(true);
            streamHandle.process(req, (ResponseHandler)responseListener);
            return responseListener.fetchResponseFuture();
        }
        if (request.getTrailingHeaders() == null) {
            request.getHeaders().setEndOfStream(false);
            DataFrame data = this.createData(request, true);
            return ((CompletableFuture)streamHandle.process(request.getHeaders(), (ResponseHandler)responseListener).thenCompose(writer -> {
                data.setStreamId(req.getStreamId());
                return writer.processPiece((StreamMsg)data);
            })).thenCompose(writer -> responseListener.fetchResponseFuture());
        }
        request.getHeaders().setEndOfStream(false);
        DataFrame data = this.createData(request, false);
        Http2Trailers trailers = request.getTrailingHeaders();
        trailers.setEndOfStream(true);
        return streamHandle.process(request.getHeaders(), (ResponseHandler)responseListener).thenCompose(writer -> this.writeStuff((StreamWriter)writer, req, data, trailers, responseListener));
    }

    private CompletableFuture<FullResponse> writeStuff(StreamWriter writer, Http2Request req, DataFrame data, Http2Trailers trailers, SingleResponseListener responseListener) {
        data.setStreamId(req.getStreamId());
        return ((CompletableFuture)writer.processPiece((StreamMsg)data).thenCompose(v -> {
            trailers.setStreamId(req.getStreamId());
            return writer.processPiece((StreamMsg)trailers);
        })).thenCompose(v -> responseListener.fetchResponseFuture());
    }

    private DataFrame createData(FullRequest request, boolean isEndOfStream) {
        DataWrapper payload = request.getPayload();
        DataFrame data = new DataFrame();
        data.setEndOfStream(isEndOfStream);
        data.setData(payload);
        return data;
    }

    @Override
    public StreamHandle openStream() {
        return this.incoming.openStream();
    }

    @Override
    public CompletableFuture<Void> sendPing() {
        return this.incoming.sendPing();
    }
}

