/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.http2client.impl;

import com.webpieces.http2engine.api.client.Http2ClientEngineFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLEngine;
import org.webpieces.http2client.api.Http2Client;
import org.webpieces.http2client.api.Http2Socket;
import org.webpieces.http2client.api.Http2SocketListener;
import org.webpieces.http2client.impl.Http2ChannelProxyImpl;
import org.webpieces.http2client.impl.Http2SocketImpl;
import org.webpieces.nio.api.ChannelManager;
import org.webpieces.nio.api.channels.TCPChannel;

public class Http2ClientImpl
implements Http2Client {
    private ChannelManager mgr;
    private Http2ClientEngineFactory factory;
    private AtomicInteger counter = new AtomicInteger();
    private AtomicInteger httpsCounter = new AtomicInteger();
    private String id;

    public Http2ClientImpl(String id, ChannelManager mgr, Http2ClientEngineFactory factory) {
        this.id = id;
        this.mgr = mgr;
        this.factory = factory;
    }

    @Override
    public Http2Socket createHttpSocket(Http2SocketListener listener) {
        int count = this.counter.getAndIncrement();
        String idForLogging = this.id + count + "Http2";
        TCPChannel channel = this.mgr.createTCPChannel(idForLogging);
        Http2ChannelProxyImpl proxy = new Http2ChannelProxyImpl(channel);
        return new Http2SocketImpl(proxy, this.factory, listener);
    }

    @Override
    public Http2Socket createHttpsSocket(SSLEngine engine, Http2SocketListener listener) {
        int count = this.httpsCounter.getAndIncrement();
        String idForLogging = this.id + count + "Https2";
        TCPChannel channel = this.mgr.createTCPChannel(idForLogging, engine);
        Http2ChannelProxyImpl proxy = new Http2ChannelProxyImpl(channel);
        return new Http2SocketImpl(proxy, this.factory, listener);
    }
}

