/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.http2client.impl;

import com.webpieces.http2.api.streaming.RequestStreamHandle;
import com.webpieces.http2engine.api.client.ClientEngineListener;
import com.webpieces.http2engine.api.client.Http2ClientEngine;
import com.webpieces.http2engine.api.client.Http2ClientEngineFactory;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.http2client.api.Http2Socket;
import org.webpieces.http2client.api.Http2SocketListener;
import org.webpieces.http2client.api.dto.FullRequest;
import org.webpieces.http2client.api.dto.FullResponse;
import org.webpieces.http2client.impl.Http2ChannelProxy;
import org.webpieces.http2client.impl.Layer1Incoming;
import org.webpieces.http2client.impl.Layer3Outgoing;
import org.webpieces.http2client.impl.ResponseCacher;

public class Http2SocketImpl
implements Http2Socket {
    private static final Logger log = LoggerFactory.getLogger(Http2SocketImpl.class);
    private Layer1Incoming incoming;
    private Layer3Outgoing outgoing;

    public Http2SocketImpl(Http2ChannelProxy channel, Http2ClientEngineFactory factory, Http2SocketListener socketListener) {
        this.outgoing = new Layer3Outgoing(channel, this);
        Http2ClientEngine parseLayer = factory.createClientParser("" + channel, (ClientEngineListener)this.outgoing);
        this.incoming = new Layer1Incoming(parseLayer, socketListener, this);
    }

    @Override
    public CompletableFuture<Void> connect(InetSocketAddress addr) {
        if (addr == null) {
            throw new IllegalArgumentException("addr cannot be null");
        }
        return ((CompletableFuture)this.outgoing.connect(addr, this.incoming).thenCompose(c -> this.incoming.sendInitialFrames())).thenApply(f -> {
            log.info("connecting complete as initial frames sent");
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.outgoing.close();
    }

    @Override
    public CompletableFuture<FullResponse> send(FullRequest request) {
        return new ResponseCacher(() -> this.openStream()).run(request);
    }

    @Override
    public RequestStreamHandle openStream() {
        return this.incoming.openStream();
    }

    @Override
    public CompletableFuture<Void> sendPing() {
        return this.incoming.sendPing();
    }
}

