/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.http2client.api;

import com.webpieces.hpack.api.HpackParser;
import com.webpieces.hpack.api.HpackParserFactory;
import com.webpieces.http2engine.api.client.Http2ClientEngineFactory;
import com.webpieces.http2engine.api.client.Http2Config;
import com.webpieces.http2engine.api.client.InjectionConfig;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.webpieces.data.api.BufferPool;
import org.webpieces.data.api.TwoPools;
import org.webpieces.http2client.api.Http2Client;
import org.webpieces.http2client.api.Http2ClientConfig;
import org.webpieces.http2client.impl.Http2ClientImpl;
import org.webpieces.metrics.MetricsCreator;
import org.webpieces.nio.api.ChannelManager;
import org.webpieces.nio.api.ChannelManagerFactory;
import org.webpieces.util.threading.NamedThreadFactory;
import org.webpieces.util.time.Time;
import org.webpieces.util.time.TimeImpl;

public abstract class Http2ClientFactory {
    public static Http2Client createHttpClient(Http2ClientConfig config, MeterRegistry metrics) {
        ExecutorService executor = Executors.newFixedThreadPool(config.getNumThreads(), (ThreadFactory)new NamedThreadFactory("httpclient"));
        MetricsCreator.monitor((MeterRegistry)metrics, (Executor)executor, (String)config.getId());
        TwoPools pool = new TwoPools(config.getId() + ".bufferpool", metrics);
        HpackParser hpackParser = HpackParserFactory.createParser((BufferPool)pool, (boolean)false);
        ChannelManagerFactory factory = ChannelManagerFactory.createFactory((MeterRegistry)metrics);
        ChannelManager mgr = factory.createMultiThreadedChanMgr("httpClientChanMgr", (BufferPool)pool, config.getBackpressureConfig(), (Executor)executor);
        InjectionConfig injConfig = new InjectionConfig(hpackParser, (Time)new TimeImpl(), config.getHttp2Config());
        return Http2ClientFactory.createHttpClient(config.getHttp2Config().getId(), mgr, injConfig);
    }

    public static Http2Client createHttpClient(Http2Config config, ChannelManager mgr, BufferPool pool) {
        HpackParser hpackParser = HpackParserFactory.createParser((BufferPool)pool, (boolean)false);
        InjectionConfig injConfig = new InjectionConfig(hpackParser, (Time)new TimeImpl(), config);
        return Http2ClientFactory.createHttpClient(config.getId(), mgr, injConfig);
    }

    public static Http2Client createHttpClient(String id, ChannelManager mgr, InjectionConfig injectionConfig) {
        Http2ClientEngineFactory engineFactory = new Http2ClientEngineFactory(injectionConfig);
        return new Http2ClientImpl(id, mgr, engineFactory);
    }
}

