/*
 * Decompiled with CFR 0.152.
 */
package com.webpieces.hpack.impl;

import com.twitter.hpack.Encoder;
import com.webpieces.http2parser.api.dto.ContinuationFrame;
import com.webpieces.http2parser.api.dto.lib.HasHeaderFragment;
import com.webpieces.http2parser.api.dto.lib.Http2Frame;
import com.webpieces.http2parser.api.dto.lib.Http2Header;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;
import org.webpieces.data.api.DataWrapperGeneratorFactory;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class HeaderEncoding {
    private static final Logger log = LoggerFactory.getLogger(HeaderEncoding.class);
    private static final DataWrapperGenerator dataGen = DataWrapperGeneratorFactory.createDataWrapperGenerator();

    public List<Http2Frame> createHeaderFrames(HasHeaderFragment initialFrame, List<Http2Header> headers, Encoder encoder, long maxFrameSize) {
        HasHeaderFragment currentFrame;
        int maxSize = (int)maxFrameSize;
        if (maxFrameSize > Integer.MAX_VALUE) {
            maxSize = Integer.MAX_VALUE;
        }
        LinkedList<Http2Frame> headerFrames = new LinkedList<Http2Frame>();
        DataWrapper serializedHeaders = this.serializeHeaders(encoder, headers);
        HasHeaderFragment lastFrame = currentFrame = initialFrame;
        DataWrapper dataLeftOver = serializedHeaders;
        while (dataLeftOver.getReadableSize() > 0) {
            lastFrame = currentFrame;
            int splitSize = Math.min(dataLeftOver.getReadableSize(), maxSize);
            List split = dataGen.split(dataLeftOver, splitSize);
            DataWrapper fragment = (DataWrapper)split.get(0);
            currentFrame.setHeaderFragment(fragment);
            headerFrames.add((Http2Frame)currentFrame);
            currentFrame = new ContinuationFrame();
            currentFrame.setStreamId(initialFrame.getStreamId());
            dataLeftOver = (DataWrapper)split.get(1);
        }
        lastFrame.setEndHeaders(true);
        return headerFrames;
    }

    public DataWrapper serializeHeaders(Encoder encoder, List<Http2Header> headers) {
        try {
            return this.serializeHeadersImpl(encoder, headers);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataWrapper serializeHeadersImpl(Encoder encoder, List<Http2Header> headers) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Encoder encoder2 = encoder;
        synchronized (encoder2) {
            for (Http2Header header : headers) {
                encoder.encodeHeader((OutputStream)out, header.getName().toLowerCase().getBytes(), header.getValue().getBytes(), false);
            }
        }
        return dataGen.wrapByteArray(out.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxHeaderTableSize(Encoder encoder, int newSize) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Encoder encoder2 = encoder;
        synchronized (encoder2) {
            encoder.setMaxHeaderTableSize((OutputStream)out, newSize);
        }
        log.info("length of out bytes=" + out.toByteArray().length);
    }
}

