/*
 * Decompiled with CFR 0.152.
 */
package com.webpieces.hpack.api.dto;

import com.webpieces.hpack.api.dto.Http2HeaderStruct;
import com.webpieces.http2parser.api.dto.lib.Http2Header;
import com.webpieces.http2parser.api.dto.lib.Http2MsgType;
import com.webpieces.http2parser.api.dto.lib.PartialStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Http2Push
implements PartialStream {
    private int streamId;
    private int promisedStreamId;
    protected List<Http2Header> headers = new ArrayList<Http2Header>();
    private transient Http2HeaderStruct headersStruct = new Http2HeaderStruct();

    public Http2Push() {
    }

    public Http2Push(List<Http2Header> headerList) {
        for (Http2Header header : headerList) {
            this.addHeader(header);
        }
    }

    public int getStreamId() {
        return this.streamId;
    }

    public void setStreamId(int streamId) {
        this.streamId = streamId;
    }

    public int getPromisedStreamId() {
        return this.promisedStreamId;
    }

    public void setPromisedStreamId(int promisedStreamId) {
        this.promisedStreamId = promisedStreamId;
    }

    public List<Http2Header> getHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    public void addHeader(Http2Header header) {
        this.headers.add(header);
        this.headersStruct.addHeader(header);
    }

    public Http2HeaderStruct getHeaderLookupStruct() {
        return this.headersStruct;
    }

    public boolean isEndOfStream() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        result = 31 * result + this.promisedStreamId;
        result = 31 * result + this.streamId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Http2Push other = (Http2Push)obj;
        if (this.headers == null ? other.headers != null : !this.headers.equals(other.headers)) {
            return false;
        }
        if (this.promisedStreamId != other.promisedStreamId) {
            return false;
        }
        return this.streamId == other.streamId;
    }

    public Http2MsgType getMessageType() {
        return Http2MsgType.PUSH_PROMISE;
    }

    public String toString() {
        return "Http2Push [streamId=" + this.streamId + ", promisedStreamId=" + this.promisedStreamId + ", headers=" + this.headers + "]";
    }
}

