/*
 * Decompiled with CFR 0.152.
 */
package com.webpieces.hpack.api.dto;

import com.webpieces.http2parser.api.dto.lib.Http2Header;
import com.webpieces.http2parser.api.dto.lib.Http2HeaderName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Http2HeaderStruct {
    private Map<String, List<Http2Header>> headers = new HashMap<String, List<Http2Header>>();

    public Http2Header getHeader(Http2HeaderName name) {
        return this.getHeader(name.getHeaderName().toLowerCase());
    }

    public List<Http2Header> getHeaders(Http2HeaderName name) {
        List<Http2Header> headers2 = this.getHeaders(name.getHeaderName().toLowerCase());
        if (headers2 == null) {
            return new ArrayList<Http2Header>();
        }
        return headers2;
    }

    public Http2Header getLastInstanceOfHeader(Http2HeaderName name) {
        List<Http2Header> headers = this.getHeaders(name.getHeaderName().toLowerCase());
        if (headers == null) {
            return null;
        }
        if (headers.size() == 0) {
            return null;
        }
        return headers.get(headers.size() - 1);
    }

    public Http2Header getHeader(String key) {
        List<Http2Header> list = this.headers.get(key.toLowerCase());
        if (list == null) {
            return null;
        }
        if (list.size() > 1) {
            throw new IllegalStateException("There are two headers in this http request with key=" + key + ". use getHeaders method instead");
        }
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public List<Http2Header> getHeaders(String key) {
        return this.headers.get(key.toLowerCase());
    }

    protected void addHeader(Http2Header header) {
        List<Http2Header> list = this.headers.get(header.getName().toLowerCase());
        if (list == null) {
            list = new ArrayList<Http2Header>();
            this.headers.put(header.getName().toLowerCase(), list);
        }
        list.add(header);
    }
}

