/*
 * Decompiled with CFR 0.152.
 */
package com.webpieces.hpack.impl;

import com.twitter.hpack.Decoder;
import com.webpieces.hpack.impl.UnmarshalStateImpl;
import com.webpieces.http2.api.dto.error.CancelReasonCode;
import com.webpieces.http2.api.dto.error.ConnectionException;
import com.webpieces.http2.api.dto.lowlevel.lib.Http2Header;
import com.webpieces.http2.api.dto.lowlevel.lib.Http2HeaderName;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.webpieces.data.api.DataWrapper;

public class HeaderDecoding {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxHeaderTableSize(Decoder decoder, int newSize) {
        Decoder decoder2 = decoder;
        synchronized (decoder2) {
            decoder.setMaxHeaderTableSize(newSize);
        }
    }

    public List<Http2Header> decode(UnmarshalStateImpl state, DataWrapper data, int streamId, Consumer<Http2Header> knownHeaders) {
        try {
            return this.decodeImpl(state, data, streamId, knownHeaders);
        }
        catch (IOException e) {
            throw new ConnectionException(CancelReasonCode.HEADER_DECODE, state.getLogId(), streamId, "Error from hpack library", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Http2Header> decodeImpl(UnmarshalStateImpl state, DataWrapper data, int streamId, Consumer<Http2Header> knownHeaders) throws IOException {
        Decoder decoder;
        ArrayList<Http2Header> headers = new ArrayList<Http2Header>();
        byte[] bytes = data.createByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        Decoder decoder2 = decoder = state.getDecoder();
        synchronized (decoder2) {
            decoder.decode((InputStream)in, (n, v, s) -> this.addToHeaders(headers, knownHeaders, n, v, s, state.getLogId(), streamId));
            decoder.endHeaderBlock();
        }
        if (data.getReadableSize() > 0 && headers.size() == 0) {
            throw new ConnectionException(CancelReasonCode.COMPRESSION_ERROR, state.getLogId(), streamId, "Header data came in, but no headers came out");
        }
        return headers;
    }

    private Object addToHeaders(List<Http2Header> headers, Consumer<Http2Header> knownHeaders, byte[] name, byte[] value, boolean sensitive, String logId, int streamId) {
        Http2HeaderName knownName;
        String h = new String(name);
        String v = new String(value);
        if (!h.equals(h.toLowerCase())) {
            throw new ConnectionException(CancelReasonCode.HEADER_NOT_LOWER_CASE, logId, streamId, "header=" + h + " was not lower case in stream=" + streamId);
        }
        Http2Header header = new Http2Header(h, v);
        headers.add(header);
        if (knownHeaders != null && (knownName = Http2HeaderName.lookup((String)h)) != null) {
            knownHeaders.accept(header);
        }
        return null;
    }
}

