/*
 * Decompiled with CFR 0.152.
 */
package com.webpieces.hpack.api.dto;

import com.webpieces.hpack.api.dto.Http2HeaderStruct;
import com.webpieces.http2parser.api.dto.lib.Http2Header;
import com.webpieces.http2parser.api.dto.lib.Http2HeaderName;
import com.webpieces.http2parser.api.dto.lib.Http2Msg;
import com.webpieces.http2parser.api.dto.lib.PriorityDetails;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class Http2Headers
implements Http2Msg {
    private int streamId;
    private boolean endOfStream = true;
    private PriorityDetails priorityDetails;
    protected List<Http2Header> headers = new ArrayList<Http2Header>();
    private transient Http2HeaderStruct headersStruct = new Http2HeaderStruct();

    public Http2Headers() {
    }

    public Http2Headers(List<Http2Header> headerList) {
        for (Http2Header header : headerList) {
            this.addHeader(header);
        }
    }

    public int getStreamId() {
        return this.streamId;
    }

    public void setStreamId(int streamId) {
        this.streamId = streamId;
    }

    public PriorityDetails getPriorityDetails() {
        return this.priorityDetails;
    }

    public void setPriorityDetails(PriorityDetails priorityDetails) {
        this.priorityDetails = priorityDetails;
    }

    public List<Http2Header> getHeaders() {
        return Collections.unmodifiableList(this.headers);
    }

    public void addHeader(Http2Header header) {
        this.headers.add(header);
        this.headersStruct.addHeader(header);
    }

    public Http2HeaderStruct getHeaderLookupStruct() {
        return this.headersStruct;
    }

    public String getSingleHeaderValue(Http2HeaderName name) {
        Http2Header header = this.getHeaderLookupStruct().getHeader(name);
        if (header == null || header.getValue() == null) {
            return null;
        }
        return header.getValue().trim();
    }

    public boolean isEndOfStream() {
        return this.endOfStream;
    }

    public void setEndOfStream(boolean lastPartOfResponse) {
        this.endOfStream = lastPartOfResponse;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.endOfStream ? 1231 : 1237);
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        result = 31 * result + (this.priorityDetails == null ? 0 : this.priorityDetails.hashCode());
        result = 31 * result + this.streamId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Http2Headers other = (Http2Headers)obj;
        if (this.endOfStream != other.endOfStream) {
            return false;
        }
        if (this.headers == null ? other.headers != null : !this.headers.equals(other.headers)) {
            return false;
        }
        if (this.priorityDetails == null ? other.priorityDetails != null : !this.priorityDetails.equals((Object)other.priorityDetails)) {
            return false;
        }
        return this.streamId == other.streamId;
    }

    public String toString() {
        String type = this.getClass().getSimpleName();
        return type + "[streamId=" + this.streamId + ", endStream=" + this.endOfStream + ", headerList=" + this.headers + ", priorityDetails=" + this.getPriorityDetails() + "]";
    }
}

