/*
 * Decompiled with CFR 0.152.
 */
package com.webpieces.hpack.impl.subparsers;

import com.webpieces.hpack.api.dto.Http2Headers;
import com.webpieces.hpack.api.subparsers.AcceptType;
import com.webpieces.hpack.api.subparsers.HeaderItem;
import com.webpieces.hpack.api.subparsers.HeaderPriorityParser;
import com.webpieces.hpack.api.subparsers.ResponseCookie;
import com.webpieces.http2parser.api.dto.lib.Http2Header;
import com.webpieces.http2parser.api.dto.lib.Http2HeaderName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderPriorityParserImpl
implements HeaderPriorityParser {
    private static final Logger log = LoggerFactory.getLogger(HeaderPriorityParserImpl.class);

    @Override
    public List<String> parseAcceptEncoding(Http2Headers req) {
        String encoding = req.getSingleHeaderValue(Http2HeaderName.ACCEPT_ENCODING);
        if (encoding == null) {
            return new ArrayList<String>();
        }
        List<String> headerItems = this.parsePriorityItems(encoding, s -> s);
        return headerItems;
    }

    @Override
    public List<Locale> parseAcceptLangFromRequest(Http2Headers req) {
        String langHeader = req.getSingleHeaderValue(Http2HeaderName.ACCEPT_LANGUAGE);
        if (langHeader == null) {
            return new ArrayList<Locale>();
        }
        List<Locale> headerItems = this.parsePriorityItems(langHeader, s -> this.parseItem((String)s));
        return headerItems;
    }

    private Locale parseItem(String subItem) {
        Locale locale = null;
        String[] l = subItem.split("_");
        switch (l.length) {
            case 2: {
                locale = new Locale(l[0], l[1]);
                break;
            }
            case 3: {
                locale = new Locale(l[0], l[1], l[2]);
                break;
            }
            default: {
                locale = new Locale(l[0]);
            }
        }
        return locale;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> List<T> parsePriorityItems(String value, Function<String, T> parseFunction) {
        void var6_8;
        ArrayList<HeaderItem<String>> headerItems = new ArrayList<HeaderItem<String>>();
        String[] stringArray = value.split(",");
        int n = stringArray.length;
        boolean bl = false;
        while (var6_8 < n) {
            String str = stringArray[var6_8];
            String[] arr = str.trim().replace("-", "_").split(";");
            String item = parseFunction.apply(arr[0]);
            if (item != null) {
                Double q = 1.0;
                for (String s : arr) {
                    if (!(s = s.trim()).startsWith("q=")) continue;
                    q = Double.parseDouble(s.substring(2).trim());
                    break;
                }
                HeaderItem<String> headerItem = new HeaderItem<String>(q, item);
                headerItems.add(headerItem);
            }
            ++var6_8;
        }
        Collections.sort(headerItems);
        ArrayList orderedItems = new ArrayList();
        for (HeaderItem headerItem : headerItems) {
            orderedItems.add(headerItem.getItem());
        }
        return orderedItems;
    }

    @Override
    public Map<String, String> parseCookiesFromRequest(Http2Headers req) {
        String cookieHeader = req.getSingleHeaderValue(Http2HeaderName.COOKIE);
        if (cookieHeader == null) {
            return new HashMap<String, String>();
        }
        String[] split = cookieHeader.split(";");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String keyValPair : split) {
            int index = keyValPair.indexOf("=");
            String name = keyValPair.substring(0, index).trim();
            String val = keyValPair.substring(index + 1).trim();
            map.put(name, val);
        }
        return map;
    }

    @Override
    public Http2Header createHeader(ResponseCookie cookie) {
        String name = cookie.getName();
        String value = cookie.getValue();
        Integer maxAgeSeconds = cookie.getMaxAgeSeconds();
        String domain = cookie.getDomain();
        String path = cookie.getPath();
        boolean isHttpOnly = cookie.isHttpOnly();
        boolean isSecure = cookie.isSecure();
        String headerVal = "";
        if (name != null) {
            headerVal = name + "=";
        } else if (value == null) {
            throw new IllegalArgumentException("value in cookie cannot be null");
        }
        headerVal = headerVal + value;
        if (maxAgeSeconds != null) {
            headerVal = headerVal + "; Max-Age=" + maxAgeSeconds;
        }
        if (domain != null) {
            headerVal = headerVal + "; domain=" + domain;
        }
        if (path != null) {
            headerVal = headerVal + "; path=" + path;
        }
        if (isSecure) {
            headerVal = headerVal + "; secure";
        }
        if (isHttpOnly) {
            headerVal = headerVal + "; HttpOnly";
        }
        return new Http2Header(Http2HeaderName.SET_COOKIE, headerVal);
    }

    @Override
    public List<AcceptType> parseAcceptFromRequest(Http2Headers req) {
        ArrayList<AcceptType> list = new ArrayList<AcceptType>();
        String acceptVal = req.getSingleHeaderValue(Http2HeaderName.ACCEPT);
        if (acceptVal == null) {
            return list;
        }
        return this.parsePriorityItems(acceptVal, s -> this.parseAcceptSubitem((String)s));
    }

    private AcceptType parseAcceptSubitem(String subItem) {
        String[] pieces = subItem.trim().split("/");
        if (pieces.length != 2) {
            log.warn("subItem not valid since missing / item=" + subItem + ". we are skipping it");
            return null;
        }
        if ("*".equals(pieces[0])) {
            if ("*".equals(pieces[1])) {
                return new AcceptType();
            }
            log.warn("subItem not valid since missing */" + pieces[1] + " is not allowed in spec.  item=" + subItem + ". we are skipping it");
            return null;
        }
        if ("*".equals(pieces[1])) {
            return new AcceptType(pieces[1]);
        }
        return new AcceptType(pieces[0], pieces[1]);
    }
}

