/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.inject.Singleton;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.elasticsearch.ElasticFailException;
import org.webpieces.elasticsearch.actions.Action;
import org.webpieces.elasticsearch.actions.AliasChange;
import org.webpieces.elasticsearch.actions.AtomicActionList;
import org.webpieces.elasticsearch.mapping.ElasticIndex;

@Singleton
public class ElasticClient {
    private static final Logger log = LoggerFactory.getLogger(ElasticClient.class);
    private RestClient client;
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public ElasticClient() {
        log.info("constructing singleton");
    }

    public void connect(String ipAddress, int port) {
        this.client = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(ipAddress, port, "https")}).build();
    }

    public void close() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Close failed");
        }
    }

    public CompletableFuture<Response> loadDocument(String index, long id, Object document) {
        Map<String, String> params = Collections.emptyMap();
        return this.performRequest("PUT", "/" + index + "/_doc/" + id, params, document, new Header[0]);
    }

    public CompletableFuture<Response> createAlias(String alias, String indexName) {
        Map<String, String> params = Collections.emptyMap();
        AliasChange addAlias = new AliasChange();
        addAlias.setIndex(indexName);
        addAlias.setAlias(alias);
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(new Action(addAlias, true));
        AtomicActionList list = new AtomicActionList();
        list.setActions(actions);
        return this.performRequest("POST", "/_aliases", params, list, new Header[0]);
    }

    public CompletableFuture<Response> getAliases(String index) {
        Map<String, String> params = Collections.emptyMap();
        return this.performRequest("GET", "/" + index + "/_alias/*", params, null, new Header[0]);
    }

    public CompletableFuture<Response> renameAlias(String previousIndex, String newIndex, String alias) {
        Map<String, String> params = Collections.emptyMap();
        AliasChange removeAlias = new AliasChange();
        removeAlias.setIndex(previousIndex);
        removeAlias.setAlias(alias);
        AliasChange addAlias = new AliasChange();
        addAlias.setIndex(newIndex);
        addAlias.setAlias(alias);
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(new Action(removeAlias, false));
        actions.add(new Action(addAlias, true));
        AtomicActionList list = new AtomicActionList();
        list.setActions(actions);
        return this.performRequest("POST", "/_aliases", params, list, new Header[0]);
    }

    public CompletableFuture<Response> deleteIndex(String name) {
        Map<String, String> params = Collections.emptyMap();
        return this.performRequest("DELETE", "/" + name, params, null, new Header[0]);
    }

    public CompletableFuture<Response> createIndex(String name, ElasticIndex index) {
        Map<String, String> params = Collections.emptyMap();
        return this.performRequest("PUT", "/" + name, params, index, new Header[0]);
    }

    public CompletableFuture<Response> performRequest(String method, String endpoint, Map<String, String> params, Object jsonObj, Header ... headers) {
        NStringEntity entity = null;
        String jsonString = null;
        if (jsonObj != null) {
            try {
                jsonString = objectMapper.writeValueAsString(jsonObj);
            }
            catch (IOException e2) {
                throw new RuntimeException("failed to translate to json object to string: " + jsonObj, e2);
            }
            entity = new NStringEntity(jsonString, ContentType.APPLICATION_JSON);
        }
        String jsonStr = jsonString;
        CompletableFuture<Response> future = new CompletableFuture<Response>();
        ToFutureListener responseListener = new ToFutureListener(future);
        RequestOptions.Builder builder = RequestOptions.DEFAULT.toBuilder();
        Header[] allHeaders = new Header[headers.length + 1];
        for (Header header : headers) {
            builder.addHeader(header.getName(), header.getValue());
        }
        builder.addHeader("Authorization", "ApiKey V0xKeEdIRUIyMGdKdjF0QlZoWmc6X0NvaU9seGZSZHFxd283SjIyYXhvdw==");
        Request requst = new Request(method, endpoint);
        requst.setEntity((HttpEntity)entity);
        requst.setOptions(builder);
        requst.addParameters(params);
        this.client.performRequestAsync(requst, (ResponseListener)responseListener);
        return ((CompletableFuture)future.handle((r, e) -> {
            if (e != null) {
                CompletableFuture f = new CompletableFuture();
                f.completeExceptionally(new RuntimeException("json failed to be processed by elastic search=" + jsonStr, (Throwable)e));
                return f;
            }
            return CompletableFuture.completedFuture(r);
        })).thenCompose(Function.identity());
    }

    private static class ToFutureListener
    implements ResponseListener {
        private CompletableFuture<Response> future;

        public ToFutureListener(CompletableFuture<Response> future) {
            this.future = future;
        }

        public void onSuccess(Response response) {
            int status = response.getStatusLine().getStatusCode();
            if (status != 201 && status != 200) {
                throw new ElasticFailException("Invalid response, response=" + response, response);
            }
            this.future.complete(response);
        }

        public void onFailure(Exception exception) {
            this.future.completeExceptionally(exception);
        }
    }
}

