/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.compiler.impl;

import java.lang.invoke.StringConcatFactory;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.webpieces.util.file.VirtualFile;

public class CompilationException
extends RuntimeException {
    private static final long serialVersionUID = -1733961137449071368L;
    private String problem;
    private VirtualFile source;
    private Integer line;
    private Integer start;
    private Integer end;
    private Charset charset;

    public CompilationException(String problem, Charset charset) {
        super(problem);
        this.problem = problem;
        this.charset = charset;
    }

    public CompilationException(VirtualFile source, Charset charset, String problem, int line, int start, int end) {
        super("Compile Error. file=" + source.getAbsolutePath() + " line=" + line + " start=" + start + " end=" + end + " error msg=" + problem);
        this.problem = problem;
        this.charset = charset;
        this.line = line;
        this.source = source;
        this.start = start;
        this.end = end;
    }

    public String getErrorTitle() {
        return String.format("Compilation error", new Object[0]);
    }

    public String getErrorDescription() {
        return String.format("The file <strong>%s</strong> could not be compiled.\nError raised is : <strong>%s</strong>", this.isSourceAvailable() ? this.source.getAbsolutePath() : "", this.problem.toString().replace("<", "&lt;"));
    }

    @Override
    public String getMessage() {
        return this.problem;
    }

    public List<String> getSource() {
        Object sourceCode = this.source.contentAsString(this.charset);
        if (this.start != -1 && this.end != -1) {
            sourceCode = this.start.equals(this.end) ? ((String)sourceCode).substring(0, this.start + 1) + "\u2193" + ((String)sourceCode).substring(this.end + 1) : StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0000\u0001\u0002\u0001", "\u0001"}, (String)((String)sourceCode).substring(0, this.start), ((String)sourceCode).substring(this.start, this.end + 1), ((String)sourceCode).substring(this.end + 1));
        }
        return Arrays.asList(((String)sourceCode).split("\n"));
    }

    public Integer getLineNumber() {
        return this.line;
    }

    public String getSourceFile() {
        return this.source.getAbsolutePath();
    }

    public Integer getSourceStart() {
        return this.start;
    }

    public Integer getSourceEnd() {
        return this.end;
    }

    public boolean isSourceAvailable() {
        return this.source != null && this.line != null;
    }
}

