/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.compiler.impl;

import org.webpieces.compiler.api.CompileConfig;
import org.webpieces.compiler.impl.ClassDefinitionLoader;
import org.webpieces.compiler.impl.CompilerWrapper;
import org.webpieces.util.file.VirtualFile;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class CompileClassMeta {
    private static final Logger log = LoggerFactory.getLogger(CompileClassMeta.class);
    public String name;
    public VirtualFile javaFile;
    public String javaSource;
    public byte[] javaByteCode;
    public Class<?> javaClass;
    public Long timestamp = 0L;
    boolean compiled;
    private CompileConfig config;

    public CompileClassMeta(CompileConfig config) {
        this.config = config;
    }

    public CompileClassMeta(String name, VirtualFile javaFile, CompileConfig config) {
        this.name = name;
        this.javaFile = javaFile;
        this.config = config;
        this.refresh();
    }

    public void refresh() {
        this.javaSource = this.javaFile.contentAsString(this.config.getFileEncoding());
        this.javaByteCode = null;
        this.compiled = false;
        this.timestamp = this.javaFile.lastModified();
    }

    public boolean isDefinable() {
        return this.compiled && this.javaClass != null;
    }

    public String getPackage() {
        int dot = this.name.lastIndexOf(46);
        return dot > -1 ? this.name.substring(0, dot) : "";
    }

    public byte[] compile(CompilerWrapper compiler, ClassDefinitionLoader loader) {
        long start = System.currentTimeMillis();
        compiler.compile(new String[]{this.name}, loader);
        if (log.isTraceEnabled()) {
            long time = System.currentTimeMillis() - start;
            log.trace(() -> time + "ms to compile class " + this.name);
        }
        return this.javaByteCode;
    }

    public void uncompile() {
        this.javaClass = null;
    }

    public void compiled(byte[] code) {
        log.info("class now compiled=" + this.name);
        this.javaByteCode = code;
        this.compiled = true;
        this.timestamp = this.javaFile.lastModified();
    }

    public String toString() {
        return this.name + " (compiled:" + this.compiled + ")";
    }
}

