/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.compiler.impl;

import java.util.List;
import org.webpieces.compiler.impl.CompileMetaMgr;
import org.webpieces.util.file.VirtualFile;

public class FileLookup {
    private List<VirtualFile> javaPath;
    private CompileMetaMgr appClassMgr;

    public FileLookup(CompileMetaMgr appClassMgr, List<VirtualFile> javaPath) {
        this.appClassMgr = appClassMgr;
        this.javaPath = javaPath;
    }

    public VirtualFile getJava(String name) {
        Object fileName = name;
        if (((String)fileName).contains("$")) {
            fileName = ((String)fileName).substring(0, ((String)fileName).indexOf("$"));
        }
        fileName = ((String)fileName).replace(".", "/") + ".java";
        for (VirtualFile path : this.javaPath) {
            VirtualFile javaFile = path.child((String)fileName);
            if (!javaFile.exists()) continue;
            return javaFile;
        }
        return null;
    }

    void scanFilesWithFilter(String filterToPackage) {
        for (VirtualFile virtualFile : this.javaPath) {
            this.scanFilesWithFilter(virtualFile, filterToPackage);
        }
    }

    void scanFilesWithFilter(VirtualFile path, String filterToPackage) {
        for (VirtualFile virtualFile : path.list()) {
            this.scanForJavaFiles("", virtualFile, filterToPackage);
        }
    }

    void scanForJavaFiles(String packageName, VirtualFile current, String filterToPackage) {
        if (!current.isDirectory()) {
            if (filterToPackage != null && !packageName.startsWith(filterToPackage)) {
                return;
            }
            if (current.getName().endsWith(".java") && !current.getName().startsWith(".")) {
                String classname = packageName + current.getName().substring(0, current.getName().length() - 5);
                this.appClassMgr.getOrCreateApplicationClass(classname, current);
            }
        } else {
            for (VirtualFile virtualFile : current.list()) {
                this.scanForJavaFiles(packageName + current.getName() + ".", virtualFile, filterToPackage);
            }
        }
    }
}

