/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.compiler.impl;

import org.webpieces.compiler.api.CompileConfig;
import org.webpieces.compiler.api.CompileOnDemand;
import org.webpieces.compiler.impl.CompileMetaMgr;
import org.webpieces.compiler.impl.CompilerWrapper;
import org.webpieces.compiler.impl.CompilingClassloader;
import org.webpieces.compiler.impl.FileLookup;

public class CompileOnDemandImpl
implements CompileOnDemand {
    private final CompileConfig config;
    private final CompileMetaMgr appClassMgr;
    private final FileLookup fileLookup;
    private final CompilerWrapper compiler;
    public CompilingClassloader classloader;

    public CompileOnDemandImpl(CompileConfig config) {
        this(config, "");
    }

    public CompileOnDemandImpl(CompileConfig config, String basePackage) {
        this.config = config;
        this.appClassMgr = new CompileMetaMgr(config);
        this.fileLookup = new FileLookup(this.appClassMgr, config.getJavaPath());
        this.compiler = new CompilerWrapper(this.appClassMgr, this.fileLookup, config);
        this.classloader = new CompilingClassloader(config, this.compiler, this.fileLookup);
        this.fileLookup.scanFilesWithFilter(basePackage);
    }

    @Override
    public Class<?> loadClass(String name) {
        if (this.classloader.isNeedToReloadJavaFiles()) {
            this.classloader = new CompilingClassloader(this.config, this.compiler, this.fileLookup);
        }
        return this.classloader.loadApplicationClass(name);
    }

    @Override
    public Class<?> loadClass(String name, boolean forceReload) {
        if (forceReload) {
            this.classloader = new CompilingClassloader(this.config, this.compiler, this.fileLookup);
        }
        return this.loadClass(name);
    }
}

