/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.compiler.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.compiler.api.CompileConfig;
import org.webpieces.util.file.VirtualFile;

public class BytecodeCache {
    private static final Logger log = LoggerFactory.getLogger(BytecodeCache.class);
    private CompileConfig config;

    public BytecodeCache(CompileConfig config) {
        this.config = config;
    }

    public void deleteBytecode(String name) {
        VirtualFile f = this.cacheFile(name.replace("/", "_").replace("{", "_").replace("}", "_").replace(":", "_"));
        if (f.exists()) {
            f.delete();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytecode(String name, String source) {
        try {
            VirtualFile f = this.cacheFile(name.replace("/", "_").replace("{", "_").replace("}", "_").replace(":", "_"));
            if (!f.exists()) {
                if (!log.isTraceEnabled()) return null;
                log.trace("Cache MISS for " + name);
                return null;
            }
            try (InputStream fis = f.openInputStream();){
                int offset = 0;
                int read = -1;
                StringBuilder hash = new StringBuilder();
                while ((read = fis.read()) > 0) {
                    hash.append((char)read);
                    ++offset;
                }
                if (!this.hash(source).equals(hash.toString())) {
                    if (log.isTraceEnabled()) {
                        log.trace("Bytecode too old (" + hash + " != " + this.hash(source) + ") for name=" + name);
                    }
                    byte[] byArray = null;
                    return byArray;
                }
                byte[] byteCode = new byte[(int)f.length() - (offset + 1)];
                fis.read(byteCode);
                byte[] byArray = byteCode;
                return byArray;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void cacheBytecode(byte[] byteCode, String name, String source) {
        try {
            VirtualFile f = this.cacheFile(name.replace("/", "_").replace("{", "_").replace("}", "_").replace(":", "_"));
            try (OutputStream fos = f.openOutputStream();){
                fos.write(this.hash(source).getBytes("utf-8"));
                fos.write(0);
                fos.write(byteCode);
            }
            if (log.isTraceEnabled()) {
                log.trace(name + "cached");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    String hash(String text) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(text.getBytes("utf-8"));
            byte[] digest = messageDigest.digest();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < digest.length; ++i) {
                int value = digest[i];
                if (value < 0) {
                    value += 256;
                }
                builder.append(Integer.toHexString(value));
            }
            return builder.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    VirtualFile cacheFile(String id) {
        VirtualFile dir = this.config.getByteCodeCacheDir();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir.child(id);
    }
}

