/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.compiler.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.compiler.api.CompileConfig;
import org.webpieces.compiler.impl.CompileClassMeta;
import org.webpieces.util.file.VirtualFile;

public class CompileMetaMgr {
    private static final Logger log = LoggerFactory.getLogger(CompileMetaMgr.class);
    Map<String, CompileClassMeta> classes = new HashMap<String, CompileClassMeta>();
    private CompileConfig config;

    public CompileMetaMgr(CompileConfig config) {
        this.config = config;
    }

    public void clear() {
        this.classes = new HashMap<String, CompileClassMeta>();
    }

    public CompileClassMeta getOrCreateApplicationClass(String name, VirtualFile current) {
        CompileClassMeta applicationClass = this.classes.get(name);
        if (applicationClass != null) {
            return applicationClass;
        }
        if (current == null) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("Adding class=" + name + " to ApplicationClassMgr");
        }
        CompileClassMeta appClass = new CompileClassMeta(name, current, this.config);
        this.classes.put(name, appClass);
        return appClass;
    }

    public CompileClassMeta getApplicationClass(String name) {
        CompileClassMeta applicationClass = this.classes.get(name);
        if (applicationClass != null) {
            return applicationClass;
        }
        return null;
    }

    public List<CompileClassMeta> all() {
        return new ArrayList<CompileClassMeta>(this.classes.values());
    }

    public void add(CompileClassMeta applicationClass) {
        this.classes.put(applicationClass.name, applicationClass);
    }

    public void remove(CompileClassMeta applicationClass) {
        this.classes.remove(applicationClass.name);
    }

    public void remove(String applicationClass) {
        this.classes.remove(applicationClass);
    }

    public boolean hasClass(String name) {
        return this.classes.containsKey(name);
    }

    public String toString() {
        return this.classes.toString();
    }
}

