/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.compiler.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.compiler.api.CompileConfig;
import org.webpieces.compiler.api.CompileOnDemand;
import org.webpieces.compiler.impl.CompileMetaMgr;
import org.webpieces.compiler.impl.CompilerWrapper;
import org.webpieces.compiler.impl.CompilingClassloader;
import org.webpieces.compiler.impl.FileLookup;

public class CompileOnDemandImpl
implements CompileOnDemand {
    private static final Logger log = LoggerFactory.getLogger(CompileOnDemandImpl.class);
    private final CompileConfig config;
    private final CompileMetaMgr appClassMgr;
    private final FileLookup fileLookup;
    private final CompilerWrapper compiler;
    public CompilingClassloader classloader;

    public CompileOnDemandImpl(CompileConfig config) {
        this(config, "");
    }

    public CompileOnDemandImpl(CompileConfig config, String basePackage) {
        this.config = config;
        this.appClassMgr = new CompileMetaMgr(config);
        this.fileLookup = new FileLookup(this.appClassMgr, config.getJavaPath());
        this.compiler = new CompilerWrapper(this.appClassMgr, this.fileLookup, config);
        this.classloader = new CompilingClassloader(config, this.compiler, this.fileLookup);
        this.fileLookup.scanFilesWithFilter(basePackage);
        log.info("using bytecode cache directory=" + config.getByteCodeCacheDir());
        log.info("using src directories to compile from=" + config.getJavaPath());
    }

    @Override
    public Class<?> loadClass(String name) {
        Class<?> clazz;
        if (this.classloader.isNeedToReloadJavaFiles()) {
            this.classloader = new CompilingClassloader(this.config, this.compiler, this.fileLookup);
        }
        if ((clazz = this.classloader.loadApplicationClass(name)) == null) {
            clazz = this.loadClassFromDefaultClassloader(name);
        }
        if (clazz == null) {
            throw new IllegalArgumentException("class name=" + name + " is not found in the source directories=" + this.config.getJavaPath() + " nor on the classpath");
        }
        return clazz;
    }

    private Class<?> loadClassFromDefaultClassloader(String name) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            return cl.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("class name=" + name + " is not found in the source directories=" + this.config.getJavaPath() + " nor on the classpath");
        }
    }

    @Override
    public Class<?> loadClass(String name, boolean forceReload) {
        if (forceReload) {
            this.classloader = new CompilingClassloader(this.config, this.compiler, this.fileLookup);
        }
        return this.loadClass(name);
    }
}

