/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.compiler.impl;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.compiler.api.CompileConfig;
import org.webpieces.compiler.impl.ClassDefinitionLoader;
import org.webpieces.compiler.impl.CompilationException;
import org.webpieces.compiler.impl.CompileClassMeta;
import org.webpieces.compiler.impl.CompileMetaMgr;
import org.webpieces.compiler.impl.FileLookup;
import org.webpieces.util.file.VirtualFile;

public class CompilerWrapper {
    private static final Logger log = LoggerFactory.getLogger(CompilerWrapper.class);
    CompileMetaMgr appClassMgr;
    Map<String, String> settings;
    private FileLookup fileLookup;
    private CompileConfig config;

    public CompilerWrapper(CompileMetaMgr appClassMgr, FileLookup lookup, CompileConfig config) {
        this.appClassMgr = appClassMgr;
        this.fileLookup = lookup;
        this.config = config;
        this.settings = new HashMap<String, String>();
        this.settings.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.settings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        this.settings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        this.settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        this.settings.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "ignore");
        this.settings.put("org.eclipse.jdt.core.encoding", "UTF-8");
        this.settings.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        this.settings.put("org.eclipse.jdt.core.compiler.codegen.methodParameters", "generate");
        String javaVersion = "1.8";
        this.settings.put("org.eclipse.jdt.core.compiler.source", javaVersion);
        this.settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", javaVersion);
        this.settings.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
        this.settings.put("org.eclipse.jdt.core.compiler.compliance", javaVersion);
    }

    public void compile(String[] classNames, final ClassDefinitionLoader loader) {
        ICompilationUnit[] compilationUnits = new CompilationUnit[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            compilationUnits[i] = new CompilationUnit(classNames[i]);
        }
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.exitOnFirstError();
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.ENGLISH);
        INameEnvironment nameEnvironment = new INameEnvironment(){

            public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
                StringBuffer result = new StringBuffer();
                for (int i = 0; i < compoundTypeName.length; ++i) {
                    if (i != 0) {
                        result.append('.');
                    }
                    result.append(compoundTypeName[i]);
                }
                return this.findType(result.toString());
            }

            public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
                StringBuffer result = new StringBuffer();
                for (int i = 0; i < packageName.length; ++i) {
                    result.append(packageName[i]);
                    result.append('.');
                }
                result.append(typeName);
                return this.findType(result.toString());
            }

            private NameEnvironmentAnswer findType(String name) {
                try {
                    char[] fileName = name.toCharArray();
                    VirtualFile file = CompilerWrapper.this.fileLookup.getJava(name);
                    CompileClassMeta applicationClass = CompilerWrapper.this.appClassMgr.getOrCreateApplicationClass(name, file);
                    if (applicationClass != null) {
                        if (applicationClass.javaByteCode != null) {
                            ClassFileReader classFileReader = new ClassFileReader(applicationClass.javaByteCode, fileName, true);
                            return new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                        }
                        CompilationUnit compilationUnit = new CompilationUnit(name);
                        return new NameEnvironmentAnswer((ICompilationUnit)compilationUnit, null);
                    }
                    byte[] bytes = loader.getClassDefinition(name);
                    if (bytes != null) {
                        ClassFileReader classFileReader = new ClassFileReader(bytes, fileName, true);
                        return new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                    }
                    return null;
                }
                catch (ClassFormatException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            public boolean isPackage(char[][] parentPackageName, char[] packageName) {
                StringBuilder sb = new StringBuilder();
                if (parentPackageName != null) {
                    for (char[] p : parentPackageName) {
                        sb.append(new String(p));
                        sb.append(".");
                    }
                }
                sb.append(new String(packageName));
                String name = sb.toString();
                if (CompilerWrapper.this.appClassMgr.getApplicationClass(name) != null) {
                    return false;
                }
                if (loader.getClassDefinition(name) != null) {
                    throw new IllegalStateException("this is reading in bytecode which I would like to avoid...do we hit this situation?");
                }
                return true;
            }

            public void cleanup() {
            }
        };
        ICompilerRequestor compilerRequestor = new ICompilerRequestor(){

            public void acceptResult(CompilationResult result) {
                CategorizedProblem[] categorizedProblemArray;
                int n;
                int n2;
                if (result.hasErrors() && (n2 = 0) < (n = (categorizedProblemArray = result.getErrors()).length)) {
                    CategorizedProblem problem = categorizedProblemArray[n2];
                    String className = new String(problem.getOriginatingFileName()).replace("/", ".");
                    className = className.substring(0, className.length() - 5);
                    String message = problem.getMessage();
                    if (problem.getID() == 268435843) {
                        message = problem.getArguments()[0] + " cannot be resolved";
                    }
                    CompileClassMeta applicationClass = CompilerWrapper.this.appClassMgr.getApplicationClass(className);
                    VirtualFile javaFile = applicationClass.javaFile;
                    throw new CompilationException(javaFile, CompilerWrapper.this.config.getFileEncoding(), message, problem.getSourceLineNumber(), problem.getSourceStart(), problem.getSourceEnd());
                }
                ClassFile[] clazzFiles = result.getClassFiles();
                for (int i = 0; i < clazzFiles.length; ++i) {
                    ClassFile clazzFile = clazzFiles[i];
                    char[][] compoundName = clazzFile.getCompoundName();
                    StringBuffer clazzName = new StringBuffer();
                    for (int j = 0; j < compoundName.length; ++j) {
                        if (j != 0) {
                            clazzName.append('.');
                        }
                        clazzName.append(compoundName[j]);
                    }
                    if (log.isTraceEnabled()) {
                        log.trace("Received Success eclipse Compiled result for=" + clazzName);
                    }
                    String name = clazzName.toString();
                    VirtualFile file = CompilerWrapper.this.fileLookup.getJava(name);
                    CompileClassMeta appClass = CompilerWrapper.this.appClassMgr.getOrCreateApplicationClass(name, file);
                    appClass.compiled(clazzFile.getBytes());
                }
            }
        };
        Compiler jdtCompiler = new Compiler(nameEnvironment, policy, this.settings, compilerRequestor, (IProblemFactory)problemFactory){

            protected void handleInternalException(Throwable e, CompilationUnitDeclaration ud, CompilationResult result) {
            }
        };
        jdtCompiler.compile(compilationUnits);
    }

    public CompileMetaMgr getAppClassMgr() {
        return this.appClassMgr;
    }

    final class CompilationUnit
    implements ICompilationUnit {
        private final String clazzName;
        private final String fileName;
        private final char[] typeName;
        private final char[][] packageName;

        CompilationUnit(String pClazzName) {
            this.clazzName = pClazzName;
            if (pClazzName.contains("$")) {
                pClazzName = pClazzName.substring(0, pClazzName.indexOf("$"));
            }
            this.fileName = pClazzName.replace('.', '/') + ".java";
            int dot = pClazzName.lastIndexOf(46);
            this.typeName = dot > 0 ? pClazzName.substring(dot + 1).toCharArray() : pClazzName.toCharArray();
            StringTokenizer izer = new StringTokenizer(pClazzName, ".");
            this.packageName = new char[izer.countTokens() - 1][];
            for (int i = 0; i < this.packageName.length; ++i) {
                this.packageName[i] = izer.nextToken().toCharArray();
            }
        }

        public char[] getFileName() {
            return this.fileName.toCharArray();
        }

        public char[] getContents() {
            return CompilerWrapper.this.appClassMgr.getApplicationClass((String)this.clazzName).javaSource.toCharArray();
        }

        public char[] getMainTypeName() {
            return this.typeName;
        }

        public char[][] getPackageName() {
            return this.packageName;
        }

        public boolean ignoreOptionalProblems() {
            return true;
        }
    }
}

