/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.compiler.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassDefinition;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import org.webpieces.compiler.api.CompileConfig;
import org.webpieces.compiler.impl.BytecodeCache;
import org.webpieces.compiler.impl.ClassDefinitionLoader;
import org.webpieces.compiler.impl.CompileClassMeta;
import org.webpieces.compiler.impl.CompileMetaMgr;
import org.webpieces.compiler.impl.CompilerWrapper;
import org.webpieces.compiler.impl.FileLookup;
import org.webpieces.compiler.impl.FileStateHashCreator;
import org.webpieces.compiler.impl.HotswapAgent;
import org.webpieces.util.file.VirtualFile;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class CompilingClassloader
extends ClassLoader
implements ClassDefinitionLoader {
    private static final Logger log = LoggerFactory.getLogger(CompilingClassloader.class);
    private final ProtectionDomain protectionDomain;
    private final CompileConfig config;
    private final BytecodeCache byteCodeCache;
    private final CompilerWrapper compiler;
    private final CompileMetaMgr appClassMgr;
    private final FileStateHashCreator classStateHashCreator;
    private final int pathHash;
    private FileLookup fileLookup;

    public CompilingClassloader(CompileConfig config, CompilerWrapper compiler, FileLookup fileLookup) {
        super(CompilingClassloader.class.getClassLoader());
        this.config = config;
        this.byteCodeCache = new BytecodeCache(config);
        this.compiler = compiler;
        this.appClassMgr = compiler.getAppClassMgr();
        this.fileLookup = fileLookup;
        this.classStateHashCreator = new FileStateHashCreator(config);
        VirtualFile pathForCodeSrc = config.getJavaPath().get(0);
        for (CompileClassMeta applicationClass : this.appClassMgr.all()) {
            applicationClass.uncompile();
        }
        this.pathHash = this.classStateHashCreator.computePathHash(config.getJavaPath());
        try {
            CodeSource codeSource = new CodeSource(new URL("file:" + pathForCodeSrc.getAbsolutePath()), (Certificate[])null);
            Permissions permissions = new Permissions();
            permissions.add(new AllPermission());
            this.protectionDomain = new ProtectionDomain(codeSource, permissions);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        Class<?> applicationClass = this.loadApplicationClass(name);
        if (applicationClass != null) {
            if (resolve) {
                this.resolveClass(applicationClass);
            }
            return applicationClass;
        }
        return super.loadClass(name, resolve);
    }

    public Class<?> loadApplicationClass(String name) {
        Class<?> maybeAlreadyLoaded = super.findLoadedClass(name);
        if (maybeAlreadyLoaded != null) {
            return maybeAlreadyLoaded;
        }
        long start = System.currentTimeMillis();
        CompileClassMeta applicationClass = this.appClassMgr.getApplicationClass(name);
        if (applicationClass == null) {
            VirtualFile file = this.fileLookup.getJava(name);
            applicationClass = this.appClassMgr.getOrCreateApplicationClass(name, file);
        }
        if (applicationClass == null) {
            return null;
        }
        if (applicationClass.isDefinable()) {
            return applicationClass.javaClass;
        }
        byte[] bc = this.byteCodeCache.getBytecode(name, applicationClass.javaSource);
        log.trace(() -> "Loading class for " + name);
        if (bc != null) {
            applicationClass.javaByteCode = bc;
            applicationClass.javaClass = this.defineClass(applicationClass.name, applicationClass.javaByteCode, 0, applicationClass.javaByteCode.length, this.protectionDomain);
            this.resolveClass(applicationClass.javaClass);
            if (log.isDebugEnabled()) {
                long time = System.currentTimeMillis() - start;
                log.trace(() -> time + "ms to load class " + name + " from cache");
            }
            return applicationClass.javaClass;
        }
        byte[] byteCode = applicationClass.javaByteCode;
        if (byteCode == null) {
            byteCode = applicationClass.compile(this.compiler, this);
        }
        if (byteCode == null) {
            throw new IllegalStateException("Bug, should not get here.  we could not compile and no exception thrown(should have had upstream fail fast exception");
        }
        applicationClass.javaClass = this.defineClass(applicationClass.name, applicationClass.javaByteCode, 0, applicationClass.javaByteCode.length, this.protectionDomain);
        this.byteCodeCache.cacheBytecode(applicationClass.javaByteCode, name, applicationClass.javaSource);
        this.resolveClass(applicationClass.javaClass);
        if (log.isTraceEnabled()) {
            long time = System.currentTimeMillis() - start;
            log.trace(() -> time + "ms to load class " + name);
        }
        return applicationClass.javaClass;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getClassDefinition(String name) {
        name = name.replace(".", "/") + ".class";
        try (InputStream is = this.getResourceAsStream(name);){
            int count;
            if (is == null) {
                byte[] byArray = null;
                return byArray;
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((count = is.read(buffer, 0, buffer.length)) > 0) {
                os.write(buffer, 0, count);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        for (VirtualFile vf : this.config.getJavaPath()) {
            VirtualFile res = vf.child(name);
            if (res == null || !res.exists()) continue;
            return res.openInputStream();
        }
        return super.getResourceAsStream(name);
    }

    @Override
    public URL getResource(String name) {
        for (VirtualFile vf : this.config.getJavaPath()) {
            VirtualFile res = vf.child(name);
            if (res == null || !res.exists()) continue;
            return res.toURL();
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (VirtualFile vf : this.config.getJavaPath()) {
            VirtualFile res = vf.child(name);
            if (res == null || !res.exists()) continue;
            urls.add(res.toURL());
        }
        Enumeration<URL> parent = super.getResources(name);
        while (parent.hasMoreElements()) {
            URL next = parent.nextElement();
            if (urls.contains(next)) continue;
            urls.add(next);
        }
        final Iterator it = urls.iterator();
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            @Override
            public URL nextElement() {
                return (URL)it.next();
            }
        };
    }

    public boolean isNeedToReloadJavaFiles() {
        int hash;
        ArrayList<CompileClassMeta> modifieds = new ArrayList<CompileClassMeta>();
        for (CompileClassMeta applicationClass : this.appClassMgr.all()) {
            if (applicationClass.javaFile.lastModified() <= applicationClass.timestamp) continue;
            applicationClass.refresh();
            modifieds.add(applicationClass);
        }
        HashSet<CompileClassMeta> modifiedWithDependencies = new HashSet<CompileClassMeta>();
        modifiedWithDependencies.addAll(modifieds);
        ArrayList<ClassDefinition> newDefinitions = new ArrayList<ClassDefinition>();
        for (CompileClassMeta applicationClass : modifiedWithDependencies) {
            if (applicationClass.compile(this.compiler, this) == null) {
                this.appClassMgr.classes.remove(applicationClass.name);
                throw new IllegalStateException("In what case can this ever happen in?");
            }
            this.byteCodeCache.cacheBytecode(applicationClass.javaByteCode, applicationClass.name, applicationClass.javaSource);
            if (applicationClass.javaClass == null) {
                this.loadApplicationClass(applicationClass.name);
            }
            newDefinitions.add(new ClassDefinition(applicationClass.javaClass, applicationClass.javaByteCode));
        }
        if (newDefinitions.size() > 0) {
            if (HotswapAgent.enabled) {
                try {
                    HotswapAgent.reload(newDefinitions.toArray(new ClassDefinition[newDefinitions.size()]));
                }
                catch (Throwable e) {
                    return true;
                }
            } else {
                return true;
            }
        }
        if ((hash = this.classStateHashCreator.computePathHash(this.config.getJavaPath())) != this.pathHash) {
            for (CompileClassMeta applicationClass : this.appClassMgr.all()) {
                if (!applicationClass.javaFile.exists()) {
                    this.appClassMgr.classes.remove(applicationClass.name);
                }
                if (!applicationClass.name.contains("$")) continue;
                this.appClassMgr.classes.remove(applicationClass.name);
                VirtualFile vf = applicationClass.javaFile;
                for (CompileClassMeta ac : this.appClassMgr.all()) {
                    if (!ac.javaFile.equals(vf)) continue;
                    this.appClassMgr.classes.remove(ac.name);
                }
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "[CompilingClassLoader " + this.appClassMgr + "]";
    }
}

