/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.compiler.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.webpieces.compiler.api.CompileConfig;
import org.webpieces.util.file.VirtualFile;

public class FileStateHashCreator {
    private final Pattern classDefFinderPattern = Pattern.compile("\\s+class\\s([a-zA-Z0-9_]+)\\s+");
    private final Map<String, FileWithClassDefs> classDefsInFileCache = new HashMap<String, FileWithClassDefs>();
    private CompileConfig config;

    public FileStateHashCreator(CompileConfig config) {
        this.config = config;
    }

    public synchronized int computePathHash(List<VirtualFile> paths) {
        StringBuffer buf = new StringBuffer();
        for (VirtualFile virtualFile : paths) {
            this.scan(buf, virtualFile);
        }
        return buf.toString().hashCode();
    }

    private void scan(StringBuffer buf, VirtualFile current) {
        if (!current.isDirectory()) {
            if (current.getName().endsWith(".java")) {
                buf.append(this.getClassDefsForFile(current));
            }
        } else if (!current.getName().startsWith(".")) {
            for (VirtualFile virtualFile : current.list()) {
                this.scan(buf, virtualFile);
            }
        }
    }

    private String getClassDefsForFile(VirtualFile current) {
        String absolutePath = current.getAbsolutePath();
        FileWithClassDefs fileWithClassDefs = this.classDefsInFileCache.get(absolutePath);
        if (fileWithClassDefs != null && fileWithClassDefs.fileNotChanges()) {
            return fileWithClassDefs.getClassDefs();
        }
        StringBuilder buf = new StringBuilder();
        Matcher matcher = this.classDefFinderPattern.matcher(current.contentAsString(this.config.getFileEncoding()));
        buf.append(current.getName());
        buf.append("(");
        while (matcher.find()) {
            buf.append(matcher.group(1));
            buf.append(",");
        }
        buf.append(")");
        String classDefs = buf.toString();
        this.classDefsInFileCache.put(absolutePath, new FileWithClassDefs(current, classDefs));
        return classDefs;
    }

    private static class FileWithClassDefs {
        private final VirtualFile file;
        private final long size;
        private final long lastModified;
        private final String classDefs;

        private FileWithClassDefs(VirtualFile file, String classDefs) {
            this.file = file;
            this.classDefs = classDefs;
            this.size = file.length();
            this.lastModified = file.lastModified();
        }

        public boolean fileNotChanges() {
            return this.size == this.file.length() && this.lastModified == this.file.lastModified();
        }

        public String getClassDefs() {
            return this.classDefs;
        }
    }
}

