/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.templatingdev.impl.source;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.webpieces.templatingdev.api.GroovyGen;
import org.webpieces.templatingdev.impl.source.TokenImpl;
import org.webpieces.templatingdev.impl.tags.ElseGen;
import org.webpieces.templatingdev.impl.tags.ElseIfGen;
import org.webpieces.templatingdev.impl.tags.IfGen;
import org.webpieces.templatingdev.impl.tags.ListGen;

@Singleton
public class GenLookup {
    private final Map<String, GroovyGen> generators = new HashMap<String, GroovyGen>();
    private final ListGen listGen;

    @Inject
    public GenLookup(ListGen listGen) {
        this.listGen = listGen;
    }

    protected void init() {
        this.put(new IfGen());
        this.put(new ElseIfGen());
        this.put(new ElseGen());
        this.put(this.listGen);
    }

    protected void put(GroovyGen generator) {
        this.generators.put(generator.getName(), generator);
    }

    public GroovyGen lookup(String genName, TokenImpl token) {
        GroovyGen gen = this.generators.get(genName);
        return gen;
    }
}

