/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.templatingdev.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.webpieces.templating.api.HtmlTagLookup;
import org.webpieces.templating.api.RouterLookup;
import org.webpieces.templating.api.Template;
import org.webpieces.templating.api.TemplateService;
import org.webpieces.templating.impl.ProdTemplateService;
import org.webpieces.templating.impl.TemplateImpl;
import org.webpieces.templatingdev.api.TemplateCompileConfig;
import org.webpieces.templatingdev.impl.HtmlToJavaClassCompiler;
import org.webpieces.templatingdev.impl.OurGroovyClassLoader;
import org.webpieces.util.exceptions.SneakyThrow;
import org.webpieces.util.file.VirtualFile;
import org.webpieces.util.file.VirtualFileClasspath;

@Singleton
public class DevTemplateService
extends ProdTemplateService {
    private HtmlToJavaClassCompiler compiler;
    private TemplateCompileConfig config;
    private HtmlTagLookup htmlTagLookup;
    private ThreadLocal<OurGroovyClassLoader> currentCl = new ThreadLocal();

    @Inject
    public DevTemplateService(RouterLookup urlLookup, HtmlTagLookup htmlTagLookup, HtmlToJavaClassCompiler compiler, TemplateCompileConfig config) {
        super(urlLookup, htmlTagLookup);
        this.htmlTagLookup = htmlTagLookup;
        this.compiler = compiler;
        this.config = config;
    }

    public void initialize() {
        this.lookup.initialize((TemplateService)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAndRunTemplateImpl(String templatePath, StringWriter out, Map<String, Object> pageArgs) {
        this.currentCl.set(new OurGroovyClassLoader());
        try {
            super.loadAndRunTemplateImpl(templatePath, out, pageArgs);
        }
        finally {
            this.currentCl.set(null);
        }
    }

    protected Template loadTemplate(String fullTemplatePath, String fullClassName) {
        try {
            return this.loadTemplateImpl(this.currentCl.get(), fullTemplatePath, fullClassName);
        }
        catch (IOException | ClassNotFoundException e) {
            throw SneakyThrow.sneak((Throwable)e);
        }
    }

    private Template loadTemplateImpl(OurGroovyClassLoader cl, String fullTemplatePath, String templateFullClassName) throws IOException, ClassNotFoundException {
        if (this.config.isMustReadClassFromFileSystem()) {
            Class<?> compiledTemplate = DevTemplateService.class.getClassLoader().loadClass(templateFullClassName);
            return new TemplateImpl(this.urlLookup, this.htmlTagLookup, compiledTemplate);
        }
        VirtualFileClasspath theResource = null;
        List<VirtualFile> srcPaths = this.config.getSrcPaths();
        for (VirtualFile f : srcPaths) {
            VirtualFile child = f.child(fullTemplatePath.substring(1));
            if (!child.exists()) continue;
            theResource = child;
            break;
        }
        if (theResource == null) {
            theResource = new VirtualFileClasspath(fullTemplatePath, DevTemplateService.class, false);
        }
        if (!theResource.exists()) {
            try {
                return super.loadTemplate(fullTemplatePath, templateFullClassName);
            }
            catch (ClassNotFoundException e) {
                FileNotFoundException exc = new FileNotFoundException("resource=" + fullTemplatePath + " was not found in classpath AND corresponding *.class file not found too");
                exc.initCause(e);
                throw exc;
            }
        }
        try (InputStream resource = theResource.openInputStream();){
            String viewSource = IOUtils.toString((InputStream)resource, (String)this.config.getFileEncoding().name());
            Class<?> compiledTemplate = this.createTemplate(cl, templateFullClassName, viewSource);
            TemplateImpl templateImpl = new TemplateImpl(this.urlLookup, this.htmlTagLookup, compiledTemplate);
            return templateImpl;
        }
    }

    private Class<?> createTemplate(OurGroovyClassLoader cl, String fullClassName, String source) throws ClassNotFoundException {
        if (!cl.isClassDefined(fullClassName)) {
            this.compiler.compile(cl, fullClassName, source);
        }
        return cl.loadClass(fullClassName);
    }
}

