/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.templatingdev.impl.tags;

import org.webpieces.templatingdev.api.GroovyGen;
import org.webpieces.templatingdev.api.ScriptOutput;
import org.webpieces.templatingdev.api.Token;
import org.webpieces.templatingdev.impl.source.TemplateToken;
import org.webpieces.templatingdev.impl.tags.RoutePathTranslator;

public abstract class ParseTagArgs
implements GroovyGen {
    private RoutePathTranslator callback;

    public ParseTagArgs(RoutePathTranslator callback) {
        this.callback = callback;
    }

    protected void generateStartAttrs(ScriptOutput sourceCode, Token token, int uniqueId) {
        String tagArgs = this.fetchArgs(token);
        sourceCode.println("enterExpression('" + token.getSourceLocation(false) + "');", token);
        sourceCode.println("_attrs" + uniqueId + " = [" + tagArgs + "];", token);
        sourceCode.println("exitExpression();", token);
        sourceCode.println();
    }

    private String fetchArgs(Token token) {
        Object tagArgs;
        String expr = token.getCleanValue();
        int indexOfSpace = expr.indexOf(" ");
        if (indexOfSpace > 0) {
            tagArgs = expr.substring(indexOfSpace + 1).trim();
            if (!((String)tagArgs).matches("^[_a-zA-Z0-9]+\\s*:.*$")) {
                tagArgs = "defaultArgument:" + (String)tagArgs;
            }
            while (((String)tagArgs).contains(TemplateToken.ACTION.getStart())) {
                tagArgs = this.replaceRouteIds(token, (String)tagArgs, indexOfSpace);
            }
            while (((String)tagArgs).contains("%[")) {
                tagArgs = this.replacePaths(token, (String)tagArgs, indexOfSpace);
            }
        } else {
            tagArgs = ":";
        }
        return tagArgs;
    }

    private String replacePaths(Token token, String tagArgs, int indexOfSpace) {
        int atIndex = tagArgs.indexOf("%[");
        int nextAtIndex = tagArgs.indexOf("]%");
        if (nextAtIndex < 0) {
            throw new IllegalArgumentException("Missing closing ]% on the route." + token.getSourceLocation(true));
        }
        String prefix = tagArgs.substring(0, atIndex);
        String relativeUrlPath = tagArgs.substring(atIndex + 2, nextAtIndex);
        String leftover = tagArgs.substring(nextAtIndex + 2);
        String groovyCode = this.callback.recordPath(relativeUrlPath, token.getSourceLocation(false));
        String groovy = prefix + groovyCode + leftover;
        return groovy;
    }

    private String replaceRouteIds(Token token, String tagArgs, int indexOfSpace) {
        int atIndex = tagArgs.indexOf(TemplateToken.ACTION.getStart());
        int nextAtIndex = tagArgs.indexOf(TemplateToken.ACTION.getEnd());
        if (nextAtIndex < 0) {
            throw new IllegalArgumentException("Missing closing ]@ on the route." + token.getSourceLocation(true));
        }
        String prefix = tagArgs.substring(0, atIndex);
        String routeInfo = tagArgs.substring(atIndex + 2, nextAtIndex);
        String leftover = tagArgs.substring(nextAtIndex + 2);
        String groovyCode = this.callback.translateRouteId(routeInfo, token);
        String groovy = prefix + groovyCode + leftover;
        return groovy;
    }
}

