/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.templating.impl.tags;

import groovy.lang.Closure;
import java.io.PrintWriter;
import java.util.Map;
import org.webpieces.templating.api.ClosureUtil;
import org.webpieces.templating.api.HtmlTag;
import org.webpieces.templating.impl.GroovyTemplateSuperclass;
import org.webpieces.templating.impl.html.HTML;

public class HtmlSetTag
implements HtmlTag {
    @Override
    public void runTag(Map<Object, Object> args, Closure<?> body, PrintWriter out, GroovyTemplateSuperclass template, String srcLocation) {
        Object name = args.get("defaultArgument");
        Object isEscaped = args.get("escaped");
        Boolean escaped = null;
        if (isEscaped instanceof Boolean) {
            escaped = (Boolean)isEscaped;
        }
        if (name != null && body != null) {
            this.storeBody(body, template, name, escaped);
            return;
        }
        this.storeSimpleProperties(args, template, escaped);
    }

    private void storeBody(Closure<?> body, GroovyTemplateSuperclass template, Object name, Boolean escaped) {
        boolean isEscaped = false;
        if (escaped != null) {
            isEscaped = escaped;
        }
        String value = ClosureUtil.toString(this.getName(), body, null);
        if (isEscaped && value != null) {
            value = HTML.htmlEscape(value);
        }
        template.putSetTagProperty(name, value);
    }

    private void storeSimpleProperties(Map<Object, Object> args, GroovyTemplateSuperclass template, Boolean escaped) {
        boolean isEscaped = true;
        if (escaped != null) {
            isEscaped = escaped;
        }
        for (Map.Entry<Object, Object> entry : args.entrySet()) {
            Object key = entry.getKey();
            if (key.toString().equals("arg")) continue;
            Object val = entry.getValue();
            if (isEscaped && val != null) {
                val = HTML.htmlEscape(val.toString());
            }
            template.putSetTagProperty(key, val);
        }
    }

    @Override
    public String getName() {
        return "set";
    }
}

