/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.templating.api;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.webpieces.templating.impl.GroovyTemplateSuperclass;
import org.webpieces.util.file.ClassUtil;

public class TemplateUtil {
    public static String convertTemplateClassToPath(String fullClass) {
        if (fullClass == null) {
            return null;
        }
        return "/" + fullClass.replace(".", "/").replace("_", ".");
    }

    public static String convertTemplatePathToClass(String fullPath) {
        if (fullPath == null) {
            return null;
        }
        String className = fullPath.substring(1);
        return className.replace(".", "_").replace("/", ".");
    }

    public static String serialize(Map<?, ?> args, String ... unless) {
        HashSet<String> unlessSet = new HashSet<String>(Arrays.asList(unless));
        unlessSet.add("defaultArgument");
        StringBuilder attrs = new StringBuilder();
        for (Object key : args.keySet()) {
            String keyStr = key.toString();
            Object value = args.get(key);
            String valueStr = "";
            if (value != null) {
                valueStr = value.toString();
            }
            if (unlessSet.contains(keyStr)) continue;
            attrs.append(" ");
            attrs.append(keyStr);
            attrs.append("=\"");
            attrs.append(valueStr);
            attrs.append("\"");
        }
        return attrs.toString();
    }

    public static String translateToProperFilePath(GroovyTemplateSuperclass callingTemplate, String superTemplatePath) {
        String className = TemplateUtil.translateToClassName(callingTemplate, superTemplatePath);
        return TemplateUtil.convertTemplateClassToPath(className);
    }

    private static String translateToClassName(GroovyTemplateSuperclass callingTemplate, String superTemplatePath) {
        if (superTemplatePath == null) {
            return null;
        }
        if (superTemplatePath.startsWith("/")) {
            return TemplateUtil.convertTemplatePathToClass(superTemplatePath);
        }
        String name = ((Object)((Object)callingTemplate)).getClass().getName();
        int lastIndexOf = name.lastIndexOf(".");
        String packageCtx = "";
        if (lastIndexOf > 0) {
            packageCtx = name.substring(0, lastIndexOf);
        }
        String superTemplatePathWithClassName = TemplateUtil.removeUnderDotFromFileName(superTemplatePath);
        String fullTempateClassName = ClassUtil.translate((String)packageCtx, (String)superTemplatePathWithClassName);
        return fullTempateClassName;
    }

    private static String removeUnderDotFromFileName(String superTemplatePath) {
        int lastIndexOfSlash = superTemplatePath.lastIndexOf("/");
        String pathWithNoFile = "";
        String fileName = superTemplatePath;
        if (lastIndexOfSlash > 0) {
            pathWithNoFile = superTemplatePath.substring(0, lastIndexOfSlash);
            fileName = superTemplatePath.substring(lastIndexOfSlash);
        }
        fileName = fileName.replace(".", "_");
        String superTemplatePathWithClassName = pathWithNoFile + fileName;
        return superTemplatePathWithClassName;
    }
}

