/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.security.modules.keycloak;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.security.modules.keycloak.KeycloakSecurityModuleConfig;
import org.webswing.security.modules.keycloak.RealmEntry;
import org.webswing.security.modules.openidconnect.OpenIdConnectClient;
import org.webswing.server.common.util.CommonUtil;
import org.webswing.server.services.security.api.AbstractWebswingUser;
import org.webswing.server.services.security.api.SecurityContext;
import org.webswing.server.services.security.api.WebswingAuthenticationException;
import org.webswing.server.services.security.extension.api.WebswingExtendableSecurityModuleConfig;
import org.webswing.server.services.security.modules.AbstractExtendableSecurityModule;
import org.webswing.server.services.security.modules.embeded.EmbededSecurityModule;
import org.webswing.server.services.security.modules.embeded.EmbededSecurityModuleConfig;
import org.webswing.server.services.security.modules.embeded.EmbededUserEntry;

public class KeycloakSecurityModule
extends AbstractExtendableSecurityModule<KeycloakSecurityModuleConfig> {
    private static final Logger log = LoggerFactory.getLogger(KeycloakSecurityModule.class);
    public static final String REALM_PARAM = "realm";
    private static final String OIDC_STATE = "KC_OpenIdConnectSessionState";
    private Map<String, OpenIdConnectClient> clients = new HashMap<String, OpenIdConnectClient>();
    private String defaultClient;
    private EmbededSecurityModule fallback;

    public KeycloakSecurityModule(KeycloakSecurityModuleConfig config) {
        super((WebswingExtendableSecurityModuleConfig)config);
    }

    public void init() {
        super.init();
        try {
            URL callback = new URL(this.replaceVar(((KeycloakSecurityModuleConfig)this.getConfig()).getCallbackUrl()));
            String clientId = this.replaceVar(((KeycloakSecurityModuleConfig)this.getConfig()).getClientId());
            String clientSecret = this.replaceVar(((KeycloakSecurityModuleConfig)this.getConfig()).getClientSecret());
            String trustedCertsPem = this.replaceVar(((KeycloakSecurityModuleConfig)this.getConfig()).getTrustedPemFile());
            File trustedCert = ((KeycloakSecurityModuleConfig)this.getConfig()).getContext().resolveFile(trustedCertsPem);
            boolean disableCertValidation = "DISABLED".equals(trustedCertsPem);
            String roleAttrName = this.replaceVar(((KeycloakSecurityModuleConfig)this.getConfig()).getRolesAttributeName());
            String userAttrName = this.replaceVar(((KeycloakSecurityModuleConfig)this.getConfig()).getUsernameAttributeName());
            String keycloakUrl = this.replaceVar(((KeycloakSecurityModuleConfig)this.getConfig()).getKeycloakUrl());
            List<RealmEntry> realms = ((KeycloakSecurityModuleConfig)this.getConfig()).getRealms();
            if (realms.size() > 0) {
                this.defaultClient = this.replaceVar(realms.get(0).getRealm());
                for (RealmEntry realm : realms) {
                    String currentRealm = this.replaceVar(realm.getRealm());
                    URL discoveryURL = new URL(String.format("%1s/realms/%2s/.well-known/openid-configuration", keycloakUrl, currentRealm));
                    URL realmCallback = new URL(CommonUtil.addParam((String)callback.toString(), (String)("realm=" + currentRealm)));
                    OpenIdConnectClient client = new OpenIdConnectClient(discoveryURL, realmCallback, clientId, clientSecret, disableCertValidation, trustedCert, roleAttrName, userAttrName);
                    client.setLogoutUrl(this.replaceVar(realm.getLogoutUrl()));
                    this.clients.put(currentRealm, client);
                }
            } else {
                throw new RuntimeException("No Keycloak realms defined. At least one has to be defined");
            }
            if (((KeycloakSecurityModuleConfig)this.getConfig()).getFallbackUsers() != null && ((KeycloakSecurityModuleConfig)this.getConfig()).getFallbackUsers().size() > 0) {
                FallbackPropertyConfig fallbackConfig = new FallbackPropertyConfig((WebswingExtendableSecurityModuleConfig)this.getConfig(), ((KeycloakSecurityModuleConfig)this.getConfig()).getFallbackUsers());
                this.fallback = new EmbededSecurityModule((EmbededSecurityModuleConfig)fallbackConfig);
            }
        }
        catch (Exception e) {
            log.error("Initializing of OpenID Connect client failed.", (Throwable)e);
            throw new RuntimeException("Initializing of OpenID Connect client failed.", e);
        }
    }

    public AbstractWebswingUser doLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        OpenIdConnectClient realmClient = this.clients.get(this.resolveRealmName(request));
        if (realmClient.isInitialized() || this.fallback == null) {
            return super.doLogin(request, response);
        }
        return this.fallback.doLogin(request, response);
    }

    private String resolveRealmName(HttpServletRequest request) {
        Map requestData = this.getLoginRequest(request);
        String r = null;
        if (requestData != null) {
            r = (String)requestData.get(REALM_PARAM);
        }
        return r == null || this.clients.get(r) == null ? this.defaultClient : r;
    }

    protected void serveLoginPartial(HttpServletRequest request, HttpServletResponse response, WebswingAuthenticationException exception) throws IOException {
        OpenIdConnectClient realmClient = this.clients.get(this.resolveRealmName(request));
        String state = UUID.randomUUID().toString().substring(0, 7);
        ((KeycloakSecurityModuleConfig)this.getConfig()).getContext().setToSecuritySession(OIDC_STATE, (Object)state);
        String url = realmClient.getOpenIDRedirectUrl(state);
        if (url != null) {
            if (exception != null) {
                this.sendPartialHtml(request, response, "errorPartial.html", exception);
            } else {
                this.sendRedirect(request, response, url);
            }
        } else {
            this.sendPartialHtml(request, response, "errorPartial.html", new Exception("Authentication server is not available."));
        }
    }

    protected AbstractWebswingUser authenticate(HttpServletRequest request) throws WebswingAuthenticationException {
        String openIdCode = OpenIdConnectClient.getCode(request);
        if (!StringUtils.isEmpty((CharSequence)openIdCode)) {
            try {
                String realmName = this.resolveRealmName(request);
                OpenIdConnectClient realmClient = this.clients.get(realmName);
                String expectedState = (String)((KeycloakSecurityModuleConfig)this.getConfig()).getContext().getFromSecuritySession(OIDC_STATE);
                realmClient.validateCodeRequest(request, expectedState);
                HashMap<String, Serializable> extraAttr = new HashMap<String, Serializable>();
                extraAttr.put(REALM_PARAM, (Serializable)((Object)realmName));
                AbstractWebswingUser user = realmClient.getUser(openIdCode, extraAttr);
                this.logSuccess(request, user.getUserId());
                AbstractWebswingUser abstractWebswingUser = user;
                return abstractWebswingUser;
            }
            catch (Exception e1) {
                this.logFailure(request, null, "Failed to authenticate." + e1.getMessage());
                log.error("Failed to authenticate", (Throwable)e1);
                throw new WebswingAuthenticationException("Failed to authenticate. " + e1.getMessage(), "login.failedToAuthenticate", (Throwable)e1);
            }
            finally {
                ((KeycloakSecurityModuleConfig)this.getConfig()).getContext().setToSecuritySession(OIDC_STATE, null);
            }
        }
        return null;
    }

    public void doLogout(HttpServletRequest request, HttpServletResponse response, AbstractWebswingUser user) throws ServletException, IOException {
        String logoutUrl = null;
        String realm = (String)user.getUserAttributes().get(REALM_PARAM);
        if (realm != null && this.clients.get(realm) != null && this.clients.get(realm).isInitialized()) {
            logoutUrl = this.replaceVar(this.clients.get(realm).getLogoutUrl());
        }
        this.logoutRedirect(request, response, logoutUrl);
    }

    private class FallbackPropertyConfig
    implements EmbededSecurityModuleConfig {
        private WebswingExtendableSecurityModuleConfig c;
        List<EmbededUserEntry> users;

        public FallbackPropertyConfig(WebswingExtendableSecurityModuleConfig c, List<EmbededUserEntry> users) {
            this.c = c;
            this.users = users;
        }

        public <T> T getValueAs(String name, Class<T> clazz) {
            return (T)this.c.getValueAs(name, clazz);
        }

        public Map<String, Object> asMap() {
            return this.c.asMap();
        }

        public SecurityContext getContext() {
            return this.c.getContext();
        }

        public List<String> getExtensions() {
            return this.c.getExtensions();
        }

        public List<EmbededUserEntry> getUsers() {
            return this.users;
        }
    }
}

