/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.security.modules.openidconnect;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.AuthorizationCodeTokenRequest;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenRequest;
import com.google.api.client.auth.openidconnect.IdToken;
import com.google.api.client.auth.openidconnect.IdTokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.json.webtoken.JsonWebToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.security.modules.openidconnect.OpenIdWebswingUser;
import org.webswing.server.services.security.api.AbstractWebswingUser;

public class OpenIdConnectClient {
    private static final Logger log = LoggerFactory.getLogger(OpenIdConnectClient.class);
    public static final String CODE = "code";
    public static final String STATE = "state";
    public static final String ISSUER = "issuer";
    public static final String AUTHORIZATION_ENDPOINT = "authorization_endpoint";
    public static final String TOKEN_ENDPOINT = "token_endpoint";
    public static final String OPENID_SCOPE = "openid profile";
    public static final String CLIENT_ID = "client_id";
    public static final String ACCESS_TOKEN = "access_token";
    public static final String ID_TOKEN = "id_token";
    public static final String REFRESH_TOKEN = "refresh_token";
    public static final String SCOPE = "scope";
    public static final String TOKEN_TYPE = "token_type";
    private final String roleAttrName;
    private final String usernameAttrName;
    private URL discovery;
    private URL callback;
    private String clientId;
    private String clientSecret;
    private String logoutUrl;
    private NetHttpTransport.Builder transportBuilder;
    private Credential.AccessMethod method;
    private ClientParametersAuthentication auth;
    private JacksonFactory jsonFactory = new JacksonFactory();
    private AuthorizationCodeFlow flow;
    private Integer pingPeriod;
    private long lastPing = System.currentTimeMillis();

    public OpenIdConnectClient(URL discovery, URL callback, String clientId, String clientSecret, boolean disableCertValidation, File trustedCert, String roleAttrName, String usernameAttrName) throws Exception {
        this.callback = callback;
        this.roleAttrName = roleAttrName;
        this.usernameAttrName = usernameAttrName;
        this.discovery = discovery;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.transportBuilder = new NetHttpTransport.Builder();
        if (disableCertValidation) {
            this.transportBuilder.doNotValidateCertificate();
        }
        if (trustedCert != null) {
            this.transportBuilder.trustCertificatesFromStream((InputStream)new FileInputStream(trustedCert));
        }
        if (StringUtils.isNotBlank((CharSequence)clientSecret)) {
            this.auth = new ClientParametersAuthentication(clientId, clientSecret);
        }
        this.method = BearerToken.authorizationHeaderAccessMethod();
        this.pingPeriod = Integer.getInteger("org.webswing.openid.ping.interval", 60) * 1000;
        this.initializeFlow();
    }

    private synchronized void initializeFlow() {
        URL tokenURI;
        URL authURI;
        String issuer;
        this.lastPing = System.currentTimeMillis();
        if (this.discovery != null) {
            try {
                log.info("Loading OpenID Connect definition from: " + this.discovery);
                HttpResponse response = this.transportBuilder.build().createRequestFactory().buildGetRequest(new GenericUrl(this.discovery)).execute();
                Map json = (Map)this.jsonFactory.createJsonParser(response.getContent()).parse(Map.class);
                if (json.get(ISSUER) == null) {
                    throw new RuntimeException("Discovery json does not define issuer field");
                }
                issuer = (String)json.get(ISSUER);
                if (json.get(AUTHORIZATION_ENDPOINT) == null) {
                    throw new RuntimeException("Discovery json does not define authorization_endpoint field");
                }
                authURI = new URL((String)json.get(AUTHORIZATION_ENDPOINT));
                if (json.get(TOKEN_ENDPOINT) == null) {
                    throw new RuntimeException("Discovery json does not define token_endpoint field");
                }
                tokenURI = new URL((String)json.get(TOKEN_ENDPOINT));
            }
            catch (IOException e) {
                log.error("Failed resolve OpenID Connect details :" + e.getMessage());
                log.debug("Failed resolve OpenID Connect details", (Throwable)e);
                this.flow = null;
                return;
            }
        } else {
            throw new RuntimeException("OpenID Connect Discovery URL is not defined.");
        }
        if (this.flow == null && authURI != null && tokenURI != null && issuer != null) {
            AuthorizationCodeFlow.Builder builder = new AuthorizationCodeFlow.Builder(this.method, (HttpTransport)this.transportBuilder.build(), (JsonFactory)this.jsonFactory, new GenericUrl(tokenURI), (HttpExecuteInterceptor)this.auth, this.clientId, authURI.toString());
            builder.setScopes(Collections.singletonList(OPENID_SCOPE));
            this.flow = builder.build();
        }
    }

    public String getOpenIDRedirectUrl(String state) throws IOException {
        if (this.isInitialized()) {
            return this.flow.newAuthorizationUrl().setRedirectUri(this.callback.toString()).setState(state).build();
        }
        return null;
    }

    public static String getCode(HttpServletRequest request) {
        return OpenIdConnectClient.getQueryParam(request, CODE);
    }

    public static String getState(HttpServletRequest request) {
        return OpenIdConnectClient.getQueryParam(request, STATE);
    }

    private static String getQueryParam(HttpServletRequest request, String paramName) {
        String[] params;
        String query = request.getQueryString();
        if (query == null) {
            return null;
        }
        for (String param : params = query.split("&")) {
            String name;
            int eq = param.indexOf(61);
            if (eq == -1 || !(name = param.substring(0, eq)).equals(paramName)) continue;
            return param.substring(eq + 1);
        }
        return null;
    }

    private static IdTokenResponse executeIdToken(TokenRequest tokenRequest) throws IOException {
        IdTokenResponse idTokenResponse = IdTokenResponse.execute((TokenRequest)tokenRequest);
        return idTokenResponse;
    }

    public AbstractWebswingUser getUser(String openIdCode, Map<String, Serializable> extraAttribs) throws IOException {
        if (this.flow != null) {
            AuthorizationCodeTokenRequest tokenRequest = this.flow.newTokenRequest(openIdCode).setRedirectUri(this.callback.toString());
            tokenRequest.set(CLIENT_ID, (Object)this.flow.getClientId());
            IdTokenResponse idTokenResponse = OpenIdConnectClient.executeIdToken((TokenRequest)tokenRequest);
            HashMap<String, Serializable> attribs = new HashMap<String, Serializable>();
            if (extraAttribs != null) {
                attribs.putAll(extraAttribs);
            }
            attribs.put(ID_TOKEN, (Serializable)((Object)idTokenResponse.getIdToken()));
            this.addToken(idTokenResponse.getAccessToken(), ACCESS_TOKEN, attribs);
            this.addToken(idTokenResponse.getRefreshToken(), REFRESH_TOKEN, attribs);
            attribs.put(SCOPE, (Serializable)((Object)idTokenResponse.getScope()));
            attribs.put(TOKEN_TYPE, (Serializable)((Object)idTokenResponse.getTokenType()));
            OpenIdWebswingUser user = new OpenIdWebswingUser(idTokenResponse.parseIdToken(), this.usernameAttrName, this.roleAttrName, attribs);
            return user;
        }
        return null;
    }

    private void addToken(String token, String tokenPrefix, Map<String, Serializable> attribs) {
        if (token != null) {
            attribs.put(tokenPrefix, (Serializable)((Object)token));
            try {
                JsonWebSignature jws = JsonWebSignature.parser((JsonFactory)this.jsonFactory).setPayloadClass(IdToken.Payload.class).parse(token);
                jws.verifySignature();
                JsonWebToken.Payload p = jws.getPayload();
                for (String claim : p.keySet()) {
                    Object value = p.get((Object)claim);
                    if (value == null) continue;
                    attribs.put(tokenPrefix + "." + claim, (Serializable)value);
                }
            }
            catch (Exception e) {
                log.debug(tokenPrefix + " can not be parsed:", (Throwable)e);
            }
        }
    }

    public boolean isInitialized() {
        if (System.currentTimeMillis() - this.lastPing > (long)this.pingPeriod.intValue()) {
            try {
                this.initializeFlow();
            }
            catch (Exception e) {
                log.error("Authentication server error:", (Throwable)e);
            }
        }
        return this.flow != null;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    public void validateCodeRequest(HttpServletRequest request, String expectedState) throws Exception {
        if (expectedState == null || !expectedState.equals(OpenIdConnectClient.getState(request))) {
            throw new Exception("Unexpected value of state parameter in code authorization request. (expected: " + expectedState + ", received: " + OpenIdConnectClient.getState(request) + ")");
        }
    }
}

