/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.security.modules.keycloak;

import java.util.ArrayList;
import java.util.List;
import org.webswing.security.modules.keycloak.RealmEntry;
import org.webswing.server.common.model.meta.ConfigField;
import org.webswing.server.common.model.meta.ConfigFieldDefaultValueObject;
import org.webswing.server.common.model.meta.ConfigFieldDefaultValueString;
import org.webswing.server.common.model.meta.ConfigFieldEditorType;
import org.webswing.server.common.model.meta.ConfigFieldOrder;
import org.webswing.server.common.model.meta.ConfigFieldVariables;
import org.webswing.server.services.security.extension.api.WebswingExtendableSecurityModuleConfig;
import org.webswing.server.services.security.modules.embeded.EmbededUserEntry;

@ConfigFieldOrder(value={"keycloakUrl", "keyCloakRealms", "callbackUrl", "clientId", "clientSecret", "trustedPemFile", "usernameAttributeName", "rolesAttributeName"})
public interface KeycloakSecurityModuleConfig
extends WebswingExtendableSecurityModuleConfig {
    @ConfigField(label="Keycloak URL")
    @ConfigFieldVariables
    public String getKeycloakUrl();

    @ConfigField(label="Realms", description="At least one realm is required. First realm is the default one.")
    @ConfigFieldDefaultValueObject(value=ArrayList.class)
    @ConfigFieldEditorType(editor=ConfigFieldEditorType.EditorType.ObjectListAsTable)
    public List<RealmEntry> getRealms();

    @ConfigField(label="Callback URL", description="URL of the webswing server where auth token will be received. Must end with /login")
    @ConfigFieldDefaultValueString(value="https://<webswing_host>:<webswing_port>/<swing_path>/login")
    @ConfigFieldVariables
    public String getCallbackUrl();

    @ConfigField(label="Client ID", description="Client ID / API key")
    @ConfigFieldVariables
    public String getClientId();

    @ConfigField(label="Client Secret", description="Leave empty if not required")
    @ConfigFieldVariables
    public String getClientSecret();

    @ConfigField(label="Trusted Certs File (PEM)", description="Trusted cert chains to establish TLS connection with Open Id server. To disable cert validation use 'DISABLED' (only for testing)")
    @ConfigFieldVariables
    public String getTrustedPemFile();

    @ConfigField(label="Username Attribute Name", description="ID Token claim name to be used as username")
    @ConfigFieldVariables
    @ConfigFieldDefaultValueString(value="preferred_username")
    public String getUsernameAttributeName();

    @ConfigField(label="Fallback Users", description="In case Keycloak Url is not reachable, fallback to local authentication. To enable fallback, add users to this list")
    @ConfigFieldVariables
    public List<EmbededUserEntry> getFallbackUsers();

    @ConfigField(label="Roles Attribute Name", description="Leave empty if not required")
    @ConfigFieldVariables
    public String getRolesAttributeName();
}

