/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.security.modules.openidconnect;

import org.webswing.server.common.model.meta.ConfigField;
import org.webswing.server.common.model.meta.ConfigFieldDefaultValueString;
import org.webswing.server.common.model.meta.ConfigFieldOrder;
import org.webswing.server.common.model.meta.ConfigFieldVariables;
import org.webswing.server.common.model.meta.ConfigType;
import org.webswing.server.services.security.extension.api.WebswingExtendableSecurityModuleConfig;

@ConfigFieldOrder(value={"importDiscoveryJson", "callbackUrl", "clientId", "clientSecret", "trustedPemFile", "usernameAttributeName", "rolesAttributeName", "logoutUrl"})
@ConfigType(metadataGenerator=OpenIDConnectMetaDataGenerator.class)
public interface OpenIDConnectSecurityModuleConfig
extends WebswingExtendableSecurityModuleConfig {
    @ConfigField(label="OpenID Connect Discovery URL")
    @ConfigFieldVariables
    public String getImportDiscoveryJson();

    @ConfigField(label="Callback URL", description="URL of the webswing server where auth token will be received. Must end with /login")
    @ConfigFieldDefaultValueString(value="https://<webswing_host>:<webswing_port>/<swing_path>/login")
    @ConfigFieldVariables
    public String getCallbackUrl();

    @ConfigField(label="Client ID", description="Client ID / API key")
    @ConfigFieldVariables
    public String getClientId();

    @ConfigField(label="Client Secret", description="Leave empty if not required")
    @ConfigFieldVariables
    public String getClientSecret();

    @ConfigField(label="Trusted Certs File (PEM)", description="Trusted cert chains to establish TLS connection with Open Id server. To disable cert validation use 'DISABLED' (only for testing)")
    @ConfigFieldVariables
    public String getTrustedPemFile();

    @ConfigField(label="Username Attribute Name", description="ID Token claim name to be used as username")
    @ConfigFieldVariables
    @ConfigFieldDefaultValueString(value="preferred_username")
    public String getUsernameAttributeName();

    @ConfigField(label="Roles Attribute Name", description="Leave empty if not required")
    @ConfigFieldVariables
    public String getRolesAttributeName();

    @ConfigField(label="Logout URL", description="Webswing will redirect to this URL after logout.")
    @ConfigFieldVariables
    public String getLogoutUrl();

    public static class OpenIDConnectMetaDataGenerator
    extends WebswingExtendableSecurityModuleConfig.ExtensionMetadataGenerator<OpenIDConnectSecurityModuleConfig> {
    }
}

