/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.security.modules.openidconnect;

import com.google.api.client.auth.openidconnect.IdToken;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.webswing.server.services.security.api.AbstractWebswingUser;

public class OpenIdWebswingUser
extends AbstractWebswingUser {
    private static final long serialVersionUID = 8364301023317885503L;
    String user;
    Map<String, Serializable> attrs = new HashMap<String, Serializable>();
    List<String> roles = new ArrayList<String>();

    public OpenIdWebswingUser(IdToken token, String usernameAttr, String roleAttr, Map<String, Serializable> extraAttribs) {
        for (String key : token.getPayload().keySet()) {
            Object value = token.getPayload().get((Object)key);
            if (value instanceof Serializable) {
                this.attrs.put(key, (Serializable)value);
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)roleAttr, (CharSequence)key)) continue;
            this.roles = this.toList(value);
        }
        if (extraAttribs != null) {
            this.attrs.putAll(extraAttribs);
        }
        this.user = this.attrs.get(usernameAttr) != null && this.attrs.get(usernameAttr) instanceof String ? (String)((Object)this.attrs.get(usernameAttr)) : token.getPayload().getSubject();
    }

    private List<String> toList(Object objValue) {
        if (objValue != null) {
            if (objValue instanceof String) {
                String value = (String)objValue;
                if (StringUtils.startsWith((CharSequence)value, (CharSequence)"[") && StringUtils.endsWith((CharSequence)value, (CharSequence)"]")) {
                    value = value.substring(1, value.length() - 1);
                }
                String[] values = StringUtils.split((String)value, (String)",");
                values = StringUtils.stripAll((String[])values);
                return Arrays.asList(values);
            }
            if (objValue instanceof List) {
                return (List)objValue;
            }
        }
        return Collections.emptyList();
    }

    public String getUserId() {
        return this.user;
    }

    public Map<String, Serializable> getUserAttributes() {
        return Collections.unmodifiableMap(this.attrs);
    }

    public boolean hasRole(String role) {
        return this.roles.contains(role);
    }
}

