/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.security.modules.openidconnect;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.security.modules.openidconnect.OpenIDConnectSecurityModuleConfig;
import org.webswing.security.modules.openidconnect.OpenIdConnectClient;
import org.webswing.server.services.security.api.AbstractWebswingUser;
import org.webswing.server.services.security.api.WebswingAuthenticationException;
import org.webswing.server.services.security.extension.api.WebswingExtendableSecurityModuleConfig;
import org.webswing.server.services.security.modules.AbstractExtendableSecurityModule;

public class OpenIDConnectSecurityModule
extends AbstractExtendableSecurityModule<OpenIDConnectSecurityModuleConfig> {
    private static final Logger log = LoggerFactory.getLogger(OpenIDConnectSecurityModule.class);
    private static final String OIDC_STATE = "OpenIdConnectSessionState";
    private OpenIdConnectClient client;

    public OpenIDConnectSecurityModule(OpenIDConnectSecurityModuleConfig config) {
        super((WebswingExtendableSecurityModuleConfig)config);
    }

    public void init() {
        super.init();
        try {
            URL callback = new URL(this.replaceVar(((OpenIDConnectSecurityModuleConfig)this.getConfig()).getCallbackUrl()));
            String trustedCertsPem = this.replaceVar(((OpenIDConnectSecurityModuleConfig)this.getConfig()).getTrustedPemFile());
            File trustedCert = ((OpenIDConnectSecurityModuleConfig)this.getConfig()).getContext().resolveFile(trustedCertsPem);
            boolean disableCertValidation = "DISABLED".equals(trustedCertsPem);
            String roleAttrName = this.replaceVar(((OpenIDConnectSecurityModuleConfig)this.getConfig()).getRolesAttributeName());
            String usernameAttrName = this.replaceVar(((OpenIDConnectSecurityModuleConfig)this.getConfig()).getUsernameAttributeName());
            URL discoveryUrl = new URL(this.replaceVar(((OpenIDConnectSecurityModuleConfig)this.getConfig()).getImportDiscoveryJson()));
            String clientSecret = this.replaceVar(((OpenIDConnectSecurityModuleConfig)this.getConfig()).getClientSecret());
            String clientId = this.replaceVar(((OpenIDConnectSecurityModuleConfig)this.getConfig()).getClientId());
            this.client = new OpenIdConnectClient(discoveryUrl, callback, clientId, clientSecret, disableCertValidation, trustedCert, roleAttrName, usernameAttrName);
        }
        catch (Exception e) {
            log.error("Initializing of OpenID Connect client failed.", (Throwable)e);
            throw new RuntimeException("Initializing of OpenID Connect client failed.", e);
        }
    }

    protected void serveLoginPartial(HttpServletRequest request, HttpServletResponse response, WebswingAuthenticationException exception) throws IOException {
        String state = UUID.randomUUID().toString().substring(0, 7);
        ((OpenIDConnectSecurityModuleConfig)this.getConfig()).getContext().setToSecuritySession(OIDC_STATE, (Object)state);
        String url = this.client.getOpenIDRedirectUrl(state);
        if (exception != null || url == null) {
            this.sendHtml(request, response, "errorPartial.html", exception);
        } else {
            this.sendRedirect(request, response, url);
        }
    }

    protected AbstractWebswingUser authenticate(HttpServletRequest request) throws WebswingAuthenticationException {
        String openIdCode = OpenIdConnectClient.getCode(request);
        if (!StringUtils.isEmpty((CharSequence)openIdCode)) {
            try {
                String expectedState = (String)((OpenIDConnectSecurityModuleConfig)this.getConfig()).getContext().getFromSecuritySession(OIDC_STATE);
                this.client.validateCodeRequest(request, expectedState);
                AbstractWebswingUser user = this.client.getUser(openIdCode, null);
                this.logSuccess(request, user.getUserId());
                AbstractWebswingUser abstractWebswingUser = user;
                return abstractWebswingUser;
            }
            catch (Exception e1) {
                this.logFailure(request, null, "Failed to authenticate." + e1.getMessage());
                log.error("Failed to authenticate", (Throwable)e1);
                throw new WebswingAuthenticationException("Failed to authenticate. " + e1.getMessage(), "login.failedToAuthenticate", (Throwable)e1);
            }
            finally {
                ((OpenIDConnectSecurityModuleConfig)this.getConfig()).getContext().setToSecuritySession(OIDC_STATE, null);
            }
        }
        return null;
    }

    public void doLogout(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String logoutUrl = this.replaceVar(((OpenIDConnectSecurityModuleConfig)this.getConfig()).getLogoutUrl());
        this.logoutRedirect(request, response, logoutUrl);
    }
}

