/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.security.modules.saml2;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.pac4j.saml.profile.SAML2Profile;
import org.webswing.server.services.security.api.AbstractWebswingUser;

public class Saml2User
extends AbstractWebswingUser {
    private final SAML2Profile profile;
    private final String name;
    private final String userAttributeName;
    private final String rolesAttributeName;
    private Map<String, Serializable> attributes = new HashMap<String, Serializable>();

    public Saml2User(SAML2Profile profile, String name, Map<String, Object> map, String userAttributeName, String rolesAttributeName) {
        this.profile = profile;
        this.name = name;
        this.userAttributeName = userAttributeName;
        this.rolesAttributeName = rolesAttributeName;
        for (Map.Entry<String, Object> e : map.entrySet()) {
            if (e.getValue() != null && e instanceof List && ((List)e.getValue()).size() == 1) {
                this.attributes.put(e.getKey(), (Serializable)((List)e.getValue()).get(0));
                continue;
            }
            if (e.getValue() instanceof List) {
                this.attributes.put(e.getKey(), new ArrayList((List)e.getValue()));
                continue;
            }
            if (e.getValue() instanceof DateTime) {
                this.attributes.put(e.getKey(), ((DateTime)e.getValue()).toDate());
                continue;
            }
            if (e.getValue() instanceof Serializable) {
                this.attributes.put(e.getKey(), (Serializable)e.getValue());
                continue;
            }
            this.attributes.put(e.getKey(), (Serializable)((Object)(e.getValue() == null ? null : e.getValue().toString())));
        }
    }

    public String getUserId() {
        Serializable user;
        if (this.userAttributeName != null && (user = this.attributes.get(this.userAttributeName)) != null && user instanceof String) {
            return (String)((Object)user);
        }
        return this.name;
    }

    public Map<String, Serializable> getUserAttributes() {
        return this.attributes;
    }

    public boolean hasRole(String role) {
        if (this.rolesAttributeName != null) {
            Serializable roles = this.attributes.get(this.rolesAttributeName);
            if (roles != null && roles instanceof String) {
                return roles.equals(role);
            }
            if (roles != null && roles instanceof Collection) {
                return ((Collection)((Object)roles)).contains(role);
            }
        }
        return false;
    }

    public SAML2Profile getProfile() {
        return this.profile;
    }
}

