/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.security.modules.saml2;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import main.Main;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.logout.handler.LogoutHandler;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.definition.CommonProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinition;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.pac4j.saml.credentials.authenticator.SAML2Authenticator;
import org.pac4j.saml.profile.SAML2Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.security.modules.saml2.SAMLException;
import org.webswing.security.modules.saml2.Saml2SecurityModuleConfig;
import org.webswing.security.modules.saml2.Saml2SessionStore;
import org.webswing.security.modules.saml2.Saml2User;
import org.webswing.security.modules.saml2.Saml2WebContext;
import org.webswing.server.services.security.api.AbstractWebswingUser;
import org.webswing.server.services.security.api.WebswingAuthenticationException;
import org.webswing.server.services.security.extension.api.WebswingExtendableSecurityModuleConfig;
import org.webswing.server.services.security.modules.AbstractExtendableSecurityModule;

public class Saml2SecurityModule
extends AbstractExtendableSecurityModule<Saml2SecurityModuleConfig> {
    private static final Logger log = LoggerFactory.getLogger(Saml2SecurityModule.class);
    private static final String SP_METADATA = "metadata";
    private static final String SAML_PARAMETER = "SAMLResponse";
    private SAML2Client client;
    private SessionStore store;
    private String userAttributeName;
    private String rolesAttributeName;

    public Saml2SecurityModule(Saml2SecurityModuleConfig config) {
        super((WebswingExtendableSecurityModuleConfig)config);
    }

    public void init() {
        super.init();
        try {
            SAML2Configuration cfg = new SAML2Configuration();
            String idpFile = ((Saml2SecurityModuleConfig)this.getConfig()).getIdentityProviderMetadataFile();
            File file = this.getFile(idpFile);
            if (file == null || !file.isFile()) {
                throw new SAMLException("The SAML2 Identity provider metadata file " + idpFile + " does not exist.");
            }
            cfg.setIdentityProviderMetadataResourceFilepath(file.getAbsolutePath());
            String consumerUrl = ((Saml2SecurityModuleConfig)this.getConfig()).getContext().replaceVariables(((Saml2SecurityModuleConfig)this.getConfig()).getServiceProviderConsumerUrl());
            if (StringUtils.isEmpty((CharSequence)consumerUrl)) {
                throw new SAMLException("The SAML2 serviceProviderConsumerUrl property must not be empty.");
            }
            String entityId = ((Saml2SecurityModuleConfig)this.getConfig()).getContext().replaceVariables(((Saml2SecurityModuleConfig)this.getConfig()).getServiceProviderEntityId());
            if (StringUtils.isEmpty((CharSequence)entityId)) {
                throw new RuntimeException("The SAML2 Service provider entityId property must not be empty.");
            }
            cfg.setServiceProviderEntityId(entityId);
            String keyStoreAlias = ((Saml2SecurityModuleConfig)this.getConfig()).getContext().replaceVariables(((Saml2SecurityModuleConfig)this.getConfig()).getDecryptionKeyAlias());
            String keyStorePwd = ((Saml2SecurityModuleConfig)this.getConfig()).getContext().replaceVariables(((Saml2SecurityModuleConfig)this.getConfig()).getKeyStorePwd());
            String keyPwd = ((Saml2SecurityModuleConfig)this.getConfig()).getContext().replaceVariables(((Saml2SecurityModuleConfig)this.getConfig()).getKeyPwd());
            cfg.setKeystorePassword(keyStorePwd);
            cfg.setKeystoreAlias(keyStoreAlias);
            cfg.setPrivateKeyPassword(keyPwd);
            String keyStore = ((Saml2SecurityModuleConfig)this.getConfig()).getContext().replaceVariables(((Saml2SecurityModuleConfig)this.getConfig()).getKeyStore());
            cfg.setKeystoreResourceFilepath(keyStore);
            cfg.setAuthnRequestSigned(((Saml2SecurityModuleConfig)this.getConfig()).isAuthnRequestSigned());
            cfg.setNameIdPolicyFormat(((Saml2SecurityModuleConfig)this.getConfig()).getNameIdPolicyFormat());
            cfg.setAuthnRequestBindingType("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            cfg.setSpLogoutRequestBindingType("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            cfg.setSpLogoutResponseBindingType("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            cfg.setLogoutHandler((LogoutHandler)new LogoutHandler<WebContext>(){

                public void destroySessionFront(WebContext context, String key) {
                }

                public void destroySessionBack(WebContext context, String key) {
                }
            });
            cfg.setMaximumAuthenticationLifetime(28800);
            cfg.setUseNameQualifier(false);
            this.store = new Saml2SessionStore(((Saml2SecurityModuleConfig)this.getConfig()).getContext());
            try {
                this.client = new SAML2Client(cfg);
                SAML2Authenticator authenticator = new SAML2Authenticator(cfg.getAttributeAsId());
                authenticator.setProfileDefinition((ProfileDefinition)new CommonProfileDefinition(p -> {
                    SAML2Profile defaultProfile = new SAML2Profile(true);
                    return defaultProfile;
                }));
                this.client.setAuthenticator((Authenticator)authenticator);
                this.client.setCallbackUrl(consumerUrl);
                this.client.init();
                this.userAttributeName = ((Saml2SecurityModuleConfig)this.getConfig()).getContext().replaceVariables(((Saml2SecurityModuleConfig)this.getConfig()).getUserAttributeName());
                this.rolesAttributeName = ((Saml2SecurityModuleConfig)this.getConfig()).getContext().replaceVariables(((Saml2SecurityModuleConfig)this.getConfig()).getRolesAttributeName());
            }
            catch (Exception e) {
                throw new SAMLException("The SAML2 client initialization failed.", e);
            }
        }
        catch (SAMLException e) {
            throw new RuntimeException("Failed to initialize SAML2 webswing security module. ", e);
        }
    }

    private File getFile(String fileName) throws SAMLException {
        File file = ((Saml2SecurityModuleConfig)this.getConfig()).getContext().resolveFile(fileName);
        if (file != null) {
            return file;
        }
        try {
            File tempFile = new File(Main.getTempDir(), Base64.encodeBase64URLSafeString((byte[])fileName.getBytes()));
            FileUtils.copyURLToFile((URL)new URL(fileName), (File)tempFile);
            return tempFile;
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (IOException e) {
            throw new SAMLException("Invalid SAML2 configuration. Failed to load file '" + fileName + "'", e);
        }
    }

    protected void serveLoginPartial(HttpServletRequest request, HttpServletResponse response, WebswingAuthenticationException exception) throws IOException {
        if (exception != null) {
            this.sendPartialHtml(request, response, "errorPartial.html", exception);
        } else {
            Saml2WebContext context = new Saml2WebContext(request, response, this.store);
            String url = this.client.getRedirectActionBuilder().redirect((WebContext)context).getLocation();
            URIBuilder urlBuilder = null;
            try {
                urlBuilder = new URIBuilder(url);
                List originalParams = urlBuilder.getQueryParams();
                urlBuilder.clearParameters();
                for (NameValuePair param : originalParams) {
                    if (!((Saml2SecurityModuleConfig)this.getConfig()).isAuthnRequestSigned() && ("SigAlg".equals(param.getName()) || "Signature".equals(param.getName()))) continue;
                    urlBuilder.addParameter(param.getName(), param.getValue());
                }
                this.sendRedirect(request, response, urlBuilder.build().toString());
            }
            catch (URISyntaxException e) {
                log.error("failed to parse SAML2 redirect url:" + url, (Throwable)e);
                this.sendRedirect(request, response, url);
            }
        }
    }

    protected AbstractWebswingUser authenticate(HttpServletRequest request) throws WebswingAuthenticationException {
        String samlResponse = request.getParameter(SAML_PARAMETER);
        if (!StringUtils.isEmpty((CharSequence)samlResponse)) {
            try {
                Saml2WebContext webCtx = new Saml2WebContext(request, this.store);
                SAML2Credentials cred = (SAML2Credentials)this.client.getCredentials((WebContext)webCtx);
                SAML2Profile profile = (SAML2Profile)this.client.getUserProfile((Credentials)cred, (WebContext)webCtx);
                this.logSuccess(request, profile.getId());
                return new Saml2User(profile, profile.getId(), profile.getAttributes(), this.userAttributeName, this.rolesAttributeName);
            }
            catch (Exception e1) {
                if (e1 instanceof HttpAction && ((HttpAction)e1).getCode() == 200) {
                    return null;
                }
                this.logFailure(request, null, "Failed to authenticate." + e1.getMessage());
                log.error("Failed to authenticate", (Throwable)e1);
                throw new WebswingAuthenticationException("Failed to auhenticate. " + e1.getMessage(), "login.failedToAuthenticate", (Throwable)e1);
            }
        }
        return null;
    }

    public AbstractWebswingUser doLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String metadata = request.getParameter(SP_METADATA);
        if (metadata != null) {
            this.serveSpMetadata(request, response);
            return null;
        }
        return super.doLogin(request, response);
    }

    public void doServeAuthenticated(AbstractWebswingUser user, String path, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String metadata = request.getParameter(SP_METADATA);
        if (metadata != null) {
            this.serveSpMetadata(request, response);
        }
        super.doServeAuthenticated(user, path, request, response);
    }

    private void serveSpMetadata(HttpServletRequest request, HttpServletResponse response) {
        J2EContext ctx = new J2EContext(request, response);
        try {
            String content = this.client.getServiceProviderMetadataResolver().getMetadata();
            ctx.setResponseStatus(200);
            ctx.setResponseContentType("application/xml");
            ctx.writeResponseContent(content);
        }
        catch (IOException e) {
            ctx.setResponseStatus(500);
            ctx.writeResponseContent("Failed to generate SP metadata xml");
            log.error("Failed to generate SP metadata xml", (Throwable)e);
        }
    }

    public void doLogout(HttpServletRequest request, HttpServletResponse response, AbstractWebswingUser user) throws ServletException, IOException {
        if (((Saml2SecurityModuleConfig)this.getConfig()).isSingleLogout() && user instanceof Saml2User) {
            Saml2WebContext context = new Saml2WebContext(request, response, this.store);
            String url = this.client.getLogoutActionBuilder().getLogoutAction((WebContext)context, (CommonProfile)((Saml2User)user).getProfile(), null).getLocation();
            this.sendRedirect(request, response, url);
        } else {
            String logoutUrl = this.replaceVar(((Saml2SecurityModuleConfig)this.getConfig()).getLogoutUrl());
            this.logoutRedirect(request, response, logoutUrl);
        }
    }
}

