/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.security.modules.saml2;

import org.webswing.server.common.model.meta.ConfigField;
import org.webswing.server.common.model.meta.ConfigFieldDefaultValueBoolean;
import org.webswing.server.common.model.meta.ConfigFieldDefaultValueString;
import org.webswing.server.common.model.meta.ConfigFieldOrder;
import org.webswing.server.common.model.meta.ConfigFieldPresets;
import org.webswing.server.common.model.meta.ConfigFieldVariables;
import org.webswing.server.common.model.meta.VariableSetName;
import org.webswing.server.services.security.extension.api.WebswingExtendableSecurityModuleConfig;

@ConfigFieldOrder(value={"identityProviderMetadataFile", "serviceProviderConsumerUrl", "serviceProviderEntityId", "authnRequestSigned", "nameIdPolicyFormat", "userAttributeName", "rolesAttributeName", "keyStore", "decryptionKeyAlias", "keyStorePwd", "keyPwd", "singleLogout", "logoutUrl"})
public interface Saml2SecurityModuleConfig
extends WebswingExtendableSecurityModuleConfig {
    @ConfigField(label="Identity Provider Metadata URI", description="Identity provide Metadata xml file local or remote URI.")
    @ConfigFieldVariables(value=VariableSetName.SwingApp)
    public String getIdentityProviderMetadataFile();

    @ConfigField(label="Service Provider Consumer URL", description="Url that verifies the SAML2 token. Should be 'https://<webswing_host>:<webswing_port>/<current_app_path>/login'. SP metadata xml will be available on same URL with '?metadata' query param.")
    @ConfigFieldDefaultValueString(value="https://<webswing_host>:<webswing_port>/<context_path>${webswing.appPath}/login")
    @ConfigFieldVariables(value=VariableSetName.SwingApp)
    public String getServiceProviderConsumerUrl();

    @ConfigField(label="Service Provider Entity ID", description="Identitficator used when registering Webswing with Idp.")
    @ConfigFieldVariables(value=VariableSetName.SwingApp)
    public String getServiceProviderEntityId();

    @ConfigField(label="AuthnRequests Signed", description="Indicates whether the Idp expects signed AuthnRequests. Idp needs to public key stored in Key store configured below to validate this signature.")
    @ConfigFieldDefaultValueBoolean(value=false)
    public boolean isAuthnRequestSigned();

    @ConfigField(label="NameId Policy Format", description="The name Id format to use for the subject.")
    @ConfigFieldPresets(value={"urn:oasis:names:tc:SAML:2.0:nameid-format:transient", "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"})
    public String getNameIdPolicyFormat();

    @ConfigField(label="Username Attribute Name", description="Name of SAML2 attribute defining the username. If empty, NameId value will be used.")
    @ConfigFieldVariables(value=VariableSetName.SwingApp)
    public String getUserAttributeName();

    @ConfigField(label="Roles Attribute Name", description="Name of SAML2 attribute that contains list of roles. Leave empty if not required")
    @ConfigFieldVariables(value=VariableSetName.SwingApp)
    @ConfigFieldDefaultValueString(value="roles")
    public String getRolesAttributeName();

    @ConfigField(label="Use Single Logout", description="Webswing will trigger Idp log-out")
    @ConfigFieldDefaultValueBoolean(value=true)
    public boolean isSingleLogout();

    @ConfigField(label="Logout URL", description="Webswing will redirect to this URL after logout.")
    public String getLogoutUrl();

    @ConfigField(label="Key Store", description="PKCS#12 or JKS Key Store file containing the private key used to decrypt the assertions returned by server. If file does not exits it will be generated.")
    @ConfigFieldVariables(value=VariableSetName.SwingApp)
    @ConfigFieldDefaultValueString(value="${webswing.homeFolder}/saml2-generatedKeystore.jks")
    public String getKeyStore();

    @ConfigField(label="Key Store Alias", description="Key alias the private key is stored under.")
    @ConfigFieldVariables(value=VariableSetName.SwingApp)
    public String getDecryptionKeyAlias();

    @ConfigField(label="Key Store Password", description="Password to access the key store.")
    @ConfigFieldVariables(value=VariableSetName.SwingApp)
    @ConfigFieldDefaultValueString(value="Change-Me!")
    public String getKeyStorePwd();

    @ConfigField(label="Private Key Password", description="Password to access the private key.")
    @ConfigFieldVariables(value=VariableSetName.SwingApp)
    @ConfigFieldDefaultValueString(value="Change-Me!")
    public String getKeyPwd();
}

