/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.security.modules.saml2;

import java.util.Optional;
import java.util.UUID;
import org.pac4j.core.context.session.SessionStore;
import org.webswing.security.modules.saml2.Saml2WebContext;
import org.webswing.server.services.security.api.SecurityContext;

public class Saml2SessionStore
implements SessionStore<Saml2WebContext> {
    private static final String SESSION_ID = "pac4jSaml2SessionId";
    private final SecurityContext sc;

    public Saml2SessionStore(SecurityContext sc) {
        this.sc = sc;
    }

    public String getOrCreateSessionId(Saml2WebContext context) {
        String id = null;
        id = (String)this.sc.getFromSecuritySession(SESSION_ID);
        if (id == null) {
            id = UUID.randomUUID().toString();
            this.sc.setToSecuritySession(SESSION_ID, (Object)id);
        }
        return id;
    }

    public Optional<Object> get(Saml2WebContext context, String key) {
        return Optional.ofNullable(this.sc.getFromSecuritySession(key));
    }

    public void set(Saml2WebContext context, String key, Object value) {
        this.sc.setToSecuritySession(key, value);
    }

    public boolean destroySession(Saml2WebContext context) {
        return false;
    }

    public Optional<Object> getTrackableSession(Saml2WebContext context) {
        return Optional.empty();
    }

    public Optional<SessionStore<Saml2WebContext>> buildFromTrackableSession(Saml2WebContext context, Object trackableSession) {
        return Optional.empty();
    }

    public boolean renewSession(Saml2WebContext context) {
        return false;
    }
}

