/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.security.modules.saml2;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.exception.TechnicalException;

public class Saml2WebContext
implements WebContext {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final SessionStore sessionStore;
    private String content = "";

    public Saml2WebContext(HttpServletRequest request, SessionStore sessionStore) {
        this(request, null, sessionStore);
    }

    public Saml2WebContext(HttpServletRequest request, HttpServletResponse response, SessionStore sessionStore) {
        this.request = request;
        this.response = response;
        this.sessionStore = sessionStore == null ? new JEESessionStore() : sessionStore;
    }

    public SessionStore getSessionStore() {
        return this.sessionStore;
    }

    public Optional<String> getRequestParameter(String name) {
        return Optional.ofNullable(this.request.getParameter(name));
    }

    public Optional<Object> getRequestAttribute(String name) {
        return Optional.ofNullable(this.request.getAttribute(name));
    }

    public void setRequestAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    public Map<String, String[]> getRequestParameters() {
        return this.request.getParameterMap();
    }

    public Optional<String> getRequestHeader(String name) {
        Enumeration names = this.request.getHeaderNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String headerName = (String)names.nextElement();
                if (headerName == null || !headerName.equalsIgnoreCase(name)) continue;
                return Optional.ofNullable(this.request.getHeader(headerName));
            }
        }
        return null;
    }

    public String getRequestMethod() {
        return this.request.getMethod();
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void writeResponseContent(String content) {
        this.content = this.content + content;
    }

    public void setResponseStatus(int code) {
        if (this.response != null) {
            this.response.setStatus(code);
        }
    }

    public void setResponseHeader(String name, String value) {
        if (this.response != null) {
            this.response.setHeader(name, value);
        }
    }

    public void setResponseContentType(String content) {
        if (this.response != null) {
            this.response.setContentType(content);
        }
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public String getFullRequestURL() {
        StringBuffer requestURL = this.request.getRequestURL();
        String queryString = this.request.getQueryString();
        if (queryString == null) {
            return requestURL.toString();
        }
        return requestURL.append('?').append(queryString).toString();
    }

    public Collection<Cookie> getRequestCookies() {
        LinkedHashSet<Cookie> pac4jCookies = new LinkedHashSet<Cookie>();
        javax.servlet.http.Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (javax.servlet.http.Cookie c : cookies) {
                Cookie cookie = new Cookie(c.getName(), c.getValue());
                cookie.setVersion(c.getVersion());
                cookie.setComment(c.getComment());
                cookie.setDomain(c.getDomain());
                cookie.setHttpOnly(c.isHttpOnly());
                cookie.setMaxAge(c.getMaxAge());
                cookie.setPath(c.getPath());
                cookie.setSecure(c.getSecure());
                pac4jCookies.add(cookie);
            }
        }
        return pac4jCookies;
    }

    public void addResponseCookie(Cookie cookie) {
        if (this.response != null) {
            javax.servlet.http.Cookie c = new javax.servlet.http.Cookie(cookie.getName(), cookie.getValue());
            c.setVersion(cookie.getVersion());
            c.setSecure(cookie.isSecure());
            c.setPath(cookie.getPath());
            c.setMaxAge(cookie.getMaxAge());
            c.setHttpOnly(cookie.isHttpOnly());
            c.setComment(cookie.getComment());
            c.setDomain(cookie.getDomain());
            this.response.addCookie(c);
        }
    }

    public String getPath() {
        String fullPath = this.request.getRequestURI();
        if (fullPath == null) {
            return "";
        }
        String context = this.request.getContextPath();
        if (context != null) {
            return fullPath.substring(context.length());
        }
        return fullPath;
    }

    public String getRequestContent() {
        try {
            return this.request.getReader().lines().reduce("", (accumulator, actual) -> accumulator.concat((String)actual));
        }
        catch (IOException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }
}

