/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.security.modules.property;

import java.io.File;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.text.PropertiesRealm;
import org.webswing.security.modules.property.PropertiesRealmSerializable;
import org.webswing.security.modules.property.PropertySecurityModuleConfig;
import org.webswing.security.modules.property.ShiroWebswingUser;
import org.webswing.server.services.security.api.AbstractWebswingUser;
import org.webswing.server.services.security.api.WebswingAuthenticationException;
import org.webswing.server.services.security.extension.api.WebswingExtendableSecurityModuleConfig;
import org.webswing.server.services.security.modules.AbstractUserPasswordSecurityModule;

public class PropertySecurityModule
extends AbstractUserPasswordSecurityModule<PropertySecurityModuleConfig> {
    private PropertiesRealm realm = new PropertiesRealmSerializable();

    public PropertySecurityModule(PropertySecurityModuleConfig config) {
        super((WebswingExtendableSecurityModuleConfig)config);
        String fileName = ((PropertySecurityModuleConfig)this.getConfig()).getFile();
        String fileNameFull = ((PropertySecurityModuleConfig)this.getConfig()).getContext().replaceVariables(fileName);
        File file = ((PropertySecurityModuleConfig)this.getConfig()).getContext().resolveFile(fileNameFull);
        if (file == null) {
            throw new RuntimeException("Unable to resolve user properties file: " + fileNameFull);
        }
        this.realm.setResourcePath("file:" + file.getPath());
        this.realm.onInit();
    }

    public void destroy() {
        this.realm.destroy();
        super.destroy();
    }

    public AbstractWebswingUser verifyUserPassword(String user, String password) throws WebswingAuthenticationException {
        AuthenticationInfo authtInfo;
        try {
            authtInfo = this.realm.getAuthenticationInfo((AuthenticationToken)new UsernamePasswordToken(user, password));
        }
        catch (AuthenticationException e) {
            throw new WebswingAuthenticationException("Username or password is not valid!", "login.invalidUserPassword", (Throwable)e);
        }
        if (authtInfo == null) {
            throw new WebswingAuthenticationException("User not found!", "login.invalidUserPassword");
        }
        return new ShiroWebswingUser((AuthorizingRealm)this.realm, authtInfo);
    }
}

