/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.security.modules.database;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.authc.credential.SimpleCredentialsMatcher;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.jdbc.JdbcRealm;
import org.webswing.security.modules.database.DatabaseSecurityModuleConfig;
import org.webswing.security.modules.database.HashType;
import org.webswing.security.modules.property.ShiroWebswingUser;
import org.webswing.server.services.security.api.AbstractWebswingUser;
import org.webswing.server.services.security.api.WebswingAuthenticationException;
import org.webswing.server.services.security.extension.api.WebswingExtendableSecurityModuleConfig;
import org.webswing.server.services.security.modules.AbstractUserPasswordSecurityModule;

public class DatabaseSecurityModule
extends AbstractUserPasswordSecurityModule<DatabaseSecurityModuleConfig> {
    private JdbcRealm realm;

    public DatabaseSecurityModule(DatabaseSecurityModuleConfig config) {
        super((WebswingExtendableSecurityModuleConfig)config);
    }

    public void init() {
        super.init();
        this.realm = new JdbcRealm();
        this.realm.setDataSource(this.initializeDataSource());
        this.realm.setAuthenticationQuery(((DatabaseSecurityModuleConfig)this.getConfig()).getAuthenticationQuery());
        this.realm.setUserRolesQuery(((DatabaseSecurityModuleConfig)this.getConfig()).getUserRolesQuery());
        this.realm.setPermissionsQuery(((DatabaseSecurityModuleConfig)this.getConfig()).getPermissionsQuery());
        this.realm.setCredentialsMatcher(this.initializeCredentialMatcher());
        this.realm.setSaltStyle(((DatabaseSecurityModuleConfig)this.getConfig()).isPasswordSalted() ? JdbcRealm.SaltStyle.COLUMN : JdbcRealm.SaltStyle.NO_SALT);
        this.realm.setPermissionsLookupEnabled(((DatabaseSecurityModuleConfig)this.getConfig()).isPermissionsEnabled());
        this.realm.init();
    }

    protected CredentialsMatcher initializeCredentialMatcher() {
        String hash = ((DatabaseSecurityModuleConfig)this.getConfig()).getHashAlgorithm();
        try {
            hash = HashType.valueOf(hash).getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (hash == null) {
            return new SimpleCredentialsMatcher();
        }
        HashedCredentialsMatcher hashedMatcher = new HashedCredentialsMatcher();
        hashedMatcher.setHashAlgorithmName(hash);
        hashedMatcher.setHashIterations(((DatabaseSecurityModuleConfig)this.getConfig()).getHashIterations());
        hashedMatcher.setStoredCredentialsHexEncoded(((DatabaseSecurityModuleConfig)this.getConfig()).getHashHexEncoded());
        return hashedMatcher;
    }

    protected DataSource initializeDataSource() throws RuntimeException {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> dsc = cl.loadClass(((DatabaseSecurityModuleConfig)this.getConfig()).getDataSourceClass());
            DataSource ds = (DataSource)dsc.newInstance();
            BeanInfo bean = Introspector.getBeanInfo(dsc);
            Map<String, String> values = ((DatabaseSecurityModuleConfig)this.getConfig()).getDataSourceProperties();
            for (PropertyDescriptor d : bean.getPropertyDescriptors()) {
                String value = values.get(d.getName());
                if (d.getWriteMethod() == null || value == null) continue;
                try {
                    Class<?> type = d.getWriteMethod().getParameterTypes()[0];
                    if (type == String.class) {
                        d.getWriteMethod().invoke((Object)ds, value);
                        continue;
                    }
                    if (type == Boolean.TYPE) {
                        d.getWriteMethod().invoke((Object)ds, Boolean.parseBoolean(value));
                        continue;
                    }
                    if (type != Integer.TYPE) continue;
                    d.getWriteMethod().invoke((Object)ds, Integer.parseInt(value));
                }
                catch (Exception e) {
                    throw new IllegalStateException("Setting the value of " + ((DatabaseSecurityModuleConfig)this.getConfig()).getDataSourceClass() + "." + d.getName() + " to " + value + " failed.", e);
                }
            }
            return ds;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to initialize DataSource " + ((DatabaseSecurityModuleConfig)this.getConfig()).getDataSourceClass(), e);
        }
    }

    public AbstractWebswingUser verifyUserPassword(String user, String password) throws WebswingAuthenticationException {
        AuthenticationInfo authtInfo;
        try {
            authtInfo = this.realm.getAuthenticationInfo((AuthenticationToken)new UsernamePasswordToken(user, password));
        }
        catch (AuthenticationException e) {
            throw new WebswingAuthenticationException("Username or password is not valid!", "login.invalidUserPassword", (Throwable)e);
        }
        if (authtInfo == null) {
            throw new WebswingAuthenticationException("User not found!", "login.invalidUserPassword");
        }
        return new ShiroWebswingUser((AuthorizingRealm)this.realm, authtInfo);
    }
}

