/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.security.modules.database;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.webswing.security.modules.database.HashType;
import org.webswing.server.common.model.meta.ConfigField;
import org.webswing.server.common.model.meta.ConfigFieldDefaultValueBoolean;
import org.webswing.server.common.model.meta.ConfigFieldDefaultValueNumber;
import org.webswing.server.common.model.meta.ConfigFieldDefaultValueObject;
import org.webswing.server.common.model.meta.ConfigFieldDefaultValueString;
import org.webswing.server.common.model.meta.ConfigFieldDiscriminator;
import org.webswing.server.common.model.meta.ConfigFieldOrder;
import org.webswing.server.common.model.meta.ConfigFieldPresets;
import org.webswing.server.common.model.meta.ConfigType;
import org.webswing.server.services.security.extension.api.WebswingExtendableSecurityModuleConfig;

@ConfigType(metadataGenerator=DatabaseSecurityModuleConfigMetaGenerator.class)
@ConfigFieldOrder(value={"dataSourceClass", "dataSourceProperties", "authenticationQuery", "userRolesQuery", "permissionsQuery", "permissionsEnabled", "passwordSalted", "hashAlgorithm"})
public interface DatabaseSecurityModuleConfig
extends WebswingExtendableSecurityModuleConfig {
    @ConfigField(label="DataSource Class", description="Database specific implementation of javax.sql.DataSource. Jar with this class should be available on classpath defined by security module.")
    @ConfigFieldPresets(value={"org.apache.derby.jdbc.ClientDataSource", "org.firebirdsql.pool.FBSimpleDataSource", "org.h2.jdbcx.JdbcDataSource", "org.hsqldb.jdbc.JDBCDataSource", "com.ibm.db2.jcc.DB2SimpleDataSource", "com.informix.jdbcx.IfxDataSource", "com.microsoft.sqlserver.jdbc.SQLServerDataSource", "com.mysql.jdbc.jdbc2.optional.MysqlDataSource", "org.mariadb.jdbc.MySQLDataSource", "oracle.jdbc.pool.OracleDataSource", "com.orientechnologies.orient.jdbc.OrientDataSource", "com.impossibl.postgres.jdbc.PGDataSource", "org.postgresql.ds.PGSimpleDataSource", "com.sap.dbtech.jdbc.DriverSapDB", "org.sqlite.SQLiteDataSource", "com.sybase.jdbc4.jdbc.SybDataSource"})
    @ConfigFieldDiscriminator
    public String getDataSourceClass();

    @ConfigField(label="DataSource Settings", description="Java bean property names and value pairs for the DataSource class specified.")
    @ConfigFieldDefaultValueObject(value=HashMap.class)
    public Map<String, String> getDataSourceProperties();

    @ConfigField(label="Authentication Query")
    @ConfigFieldDefaultValueString(value="select password, password_salt from users where username = ?")
    public String getAuthenticationQuery();

    @ConfigField(label="User Roles Query")
    @ConfigFieldDefaultValueString(value="select role_name from user_roles where username = ?")
    public String getUserRolesQuery();

    @ConfigField(label="Permissions Query")
    @ConfigFieldDefaultValueString(value="select permission from roles_permissions where role_name = ?")
    public String getPermissionsQuery();

    @ConfigField(label="Resolve Permissions")
    @ConfigFieldDefaultValueBoolean(value=false)
    public boolean isPermissionsEnabled();

    @ConfigField(label="Salted Password Hash")
    @ConfigFieldDefaultValueBoolean(value=true)
    public boolean isPasswordSalted();

    @ConfigField(label="Hash Matcher Algorithm")
    @ConfigFieldPresets(enumClass=HashType.class)
    @ConfigFieldDefaultValueString(value="NONE")
    public String getHashAlgorithm();

    @ConfigField(label="Hash Iterations")
    @ConfigFieldDefaultValueNumber(value=1.0)
    public int getHashIterations();

    @ConfigField(label="Hash Hex Encoded", description="Select if password hash in stored as Hex value, otherwise Base64 encoded hash is expected.")
    @ConfigFieldDefaultValueBoolean(value=false)
    public boolean getHashHexEncoded();

    public static class DatabaseSecurityModuleConfigMetaGenerator
    extends WebswingExtendableSecurityModuleConfig.ExtensionMetadataGenerator<DatabaseSecurityModuleConfig> {
        protected String[] getPresets(DatabaseSecurityModuleConfig config, ClassLoader cl, String propertyName, Method readMethod) {
            if (propertyName.equals("dataSourceProperties")) {
                try {
                    ArrayList<String> presets = new ArrayList<String>();
                    Class<?> dsc = cl.loadClass(config.getDataSourceClass());
                    BeanInfo bean = Introspector.getBeanInfo(dsc);
                    for (PropertyDescriptor d : bean.getPropertyDescriptors()) {
                        Class<?> type;
                        if (d.getWriteMethod() == null || (type = d.getWriteMethod().getParameterTypes()[0]) != String.class && type != Boolean.TYPE && type != Integer.TYPE) continue;
                        presets.add(d.getName());
                    }
                    return presets.toArray(new String[presets.size()]);
                }
                catch (Throwable e) {
                    return null;
                }
            }
            return super.getPresets((Object)config, cl, propertyName, readMethod);
        }
    }
}

