/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.classloader;

import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.webswing.classloader.SwingClassloader;
import org.webswing.ext.services.SwingClassLoaderFactoryService;

public class SwingClassLoaderFactory
implements SwingClassLoaderFactoryService {
    private static SwingClassLoaderFactory impl;

    public static SwingClassLoaderFactory getInstance() {
        if (impl == null) {
            impl = new SwingClassLoaderFactory();
        }
        return impl;
    }

    private SwingClassLoaderFactory() {
    }

    public ClassLoader createSwingClassLoader(URL[] classpath, ClassLoader parent) {
        return new SwingClassLoaderWithAccessControl(classpath, parent);
    }

    private class SwingClassLoaderWithAccessControl
    extends SwingClassloader {
        private final AccessControlContext acc;

        public SwingClassLoaderWithAccessControl(URL[] classpath, ClassLoader parent) {
            super(classpath, parent);
            this.acc = AccessController.getContext();
        }

        @Override
        protected synchronized Class<?> loadClass(final String class_name, final boolean resolve) throws ClassNotFoundException {
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                    @Override
                    public Class<?> run() throws ClassNotFoundException {
                        return SwingClassLoaderWithAccessControl.this.superLoadClass(class_name, resolve);
                    }
                }, this.acc);
            }
            catch (PrivilegedActionException e) {
                if (e.getException() instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)e.getException();
                }
                throw new ClassNotFoundException(e.getMessage(), e);
            }
        }

        private synchronized Class<?> superLoadClass(String class_name, boolean resolve) throws ClassNotFoundException {
            return super.loadClass(class_name, resolve);
        }
    }
}

