/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.classloader;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandler;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.CPInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.ClassLoaderRepository;
import org.apache.commons.io.IOUtils;
import org.webswing.classloader.ClassModificationRegister;
import org.webswing.util.AppLogger;
import org.webswing.util.ClassLoaderUtil;
import sun.security.util.SecurityConstants;

public class SwingClassloader
extends URLClassLoader {
    private static BiMap<String, String> classReplacementMapping;
    private static BiMap<String, String> methodReplacementMapping;
    private static BiMap<String, String> methodOverrideMapping;
    private static URLStreamHandler originalJarHandler;
    private Hashtable<String, Class<?>> classes = new Hashtable();
    private String[] ignored_packages;
    private ClassModificationRegister modRegister = new ClassModificationRegister();
    private ClassLoaderRepository repository;
    private final FallbackURLClassLoader repoClassLoader;

    public SwingClassloader(URL[] classpath, ClassLoader parent) {
        super(new URL[0], parent);
        this.ignored_packages = new String[]{"org.webswing.special.", "org.webswing.model.", "org.webswing.toolkit.", "netscape.javascript."};
        this.repoClassLoader = new FallbackURLClassLoader(classpath);
        this.repository = new ClassLoaderRepository((ClassLoader)this.repoClassLoader);
    }

    @Override
    protected synchronized Class<?> loadClass(String class_name, boolean resolve) throws ClassNotFoundException {
        Class<?> cl = null;
        cl = this.classes.get(class_name);
        if (cl == null) {
            try {
                cl = SwingClassloader.getSystemClassLoader().loadClass(class_name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (cl == null) {
                for (int i = 0; i < this.ignored_packages.length; ++i) {
                    if (!class_name.startsWith(this.ignored_packages[i])) continue;
                    cl = this.getParent().loadClass(class_name);
                    break;
                }
            }
            if (cl == null) {
                cl = this.findClass(class_name);
            }
            if (resolve) {
                this.resolveClass(cl);
            }
        }
        this.classes.put(class_name, cl);
        return cl;
    }

    @Override
    protected void addURL(URL url) {
        try {
            Method m = this.repoClassLoader.getClass().getSuperclass().getDeclaredMethod("addURL", URL.class);
            m.setAccessible(true);
            m.invoke((Object)this.repoClassLoader, url);
        }
        catch (Exception e) {
            AppLogger.error((String)"Failed to addURL to SwingClassloader", (Object[])new Object[]{e});
        }
    }

    protected void addAppURL(URL url) {
        this.addURL(url);
    }

    private JavaClass createClass(String class_name) {
        throw new RuntimeException("not creating classes");
    }

    protected JavaClass modifyClass(JavaClass clazz) {
        if (ClassLoaderUtil.isInPackage(clazz.getPackageName(), new String[]{"org.webswing"})) {
            return clazz;
        }
        this.definePackage(clazz.getPackageName());
        if (!classReplacementMapping.values().contains(clazz.getClassName())) {
            ClassGen cg = new ClassGen(clazz);
            ConstantPoolGen cp = cg.getConstantPool();
            InstructionFactory f = new InstructionFactory(cg);
            boolean rerouted = SwingClassloader.rerouteMehods(clazz, cg, cp, f);
            this.modRegister.setModificationState(clazz.getClassName(), rerouted);
            return cg.getJavaClass();
        }
        return clazz;
    }

    private void definePackage(String pkgname) {
        Package s = this.getPackage(pkgname);
        if (s == null) {
            super.definePackage(pkgname, null, null, null, null, null, null, null);
        }
    }

    private void overrideMehods(ClassGen cg, ConstantPoolGen cp, InstructionFactory f) {
        for (String method : methodOverrideMapping.keySet()) {
            String[] md = method.split(" ");
            if (!md[0].equals(cg.getClassName())) continue;
            String methodName = md[1];
            String signature = md[2];
            Type returnType = Type.getReturnType((String)signature);
            Type[] signatureTypes = Type.getArgumentTypes((String)signature);
            org.apache.bcel.classfile.Method m = cg.containsMethod(methodName, signature);
            InstructionList il = new InstructionList();
            MethodGen mg = m == null ? new MethodGen(1, returnType, signatureTypes, ClassLoaderUtil.createArgNames(signatureTypes.length), methodName, cg.getClassName(), il, cp) : new MethodGen(m, cg.getClassName(), cp);
            String[] overridenMd = ((String)methodOverrideMapping.get((Object)method)).split(" ");
            String overridenClassName = overridenMd[0];
            String overridenMethodName = overridenMd[1];
            Type[] overridenArgs = new Type[signatureTypes.length + 1];
            for (int i = 0; i <= signatureTypes.length; ++i) {
                overridenArgs[i] = i == 0 ? new ObjectType(classReplacementMapping.containsValue((Object)cg.getClassName()) ? (String)classReplacementMapping.inverse().get((Object)cg.getClassName()) : cg.getClassName()) : signatureTypes[i - 1];
                il.append((Instruction)new ALOAD(i));
            }
            il.append((Instruction)f.createInvoke(overridenClassName, overridenMethodName, returnType, overridenArgs, (short)184));
            if (!returnType.equals((Object)Type.VOID)) {
                il.append((Instruction)InstructionConstants.RETURN);
            }
            mg.setMaxStack();
            cg.addMethod(mg.getMethod());
            il.dispose();
        }
    }

    private static boolean rerouteMehods(JavaClass clazz, ClassGen cg, ConstantPoolGen cp, InstructionFactory f) {
        HashMap<Integer, Integer> indexReplacementMap = new HashMap<Integer, Integer>();
        for (String methodDef : methodReplacementMapping.keySet()) {
            String[] md = methodDef.split(" ");
            int methodIndex = cp.lookupMethodref(md[0], md[1], md[2]);
            if (methodIndex == -1) continue;
            String[] replace = ((String)methodReplacementMapping.get((Object)methodDef)).split(" ");
            int replacementIndex = cp.addMethodref(replace[0], replace[1], replace[2]);
            indexReplacementMap.put(methodIndex, replacementIndex);
        }
        if (indexReplacementMap.size() > 0) {
            for (org.apache.bcel.classfile.Method m : cg.getMethods()) {
                MethodGen mg = new MethodGen(m, clazz.getClassName(), cp);
                InstructionList il = mg.getInstructionList();
                if (il == null) continue;
                boolean dirtyFlag = false;
                for (Instruction instruction : il.getInstructions()) {
                    CPInstruction i;
                    if (!(instruction instanceof CPInstruction) || !indexReplacementMap.containsKey((i = (CPInstruction)instruction).getIndex())) continue;
                    InstructionHandle handle = ClassLoaderUtil.findInstructionHandle(il, (Instruction)i);
                    INVOKESTATIC replacedInstruction = new INVOKESTATIC(((Integer)indexReplacementMap.get(i.getIndex())).intValue());
                    handle.setInstruction((Instruction)replacedInstruction);
                    dirtyFlag = true;
                }
                if (!dirtyFlag) continue;
                il.setPositions();
                mg.setInstructionList(il);
                mg.setMaxStack();
                mg.setMaxLocals();
                mg.removeLineNumbers();
                cg.replaceMethod(m, mg.getMethod());
                il.dispose();
            }
            return true;
        }
        return false;
    }

    private void rerouteSwingClasses(JavaClass clazz, ClassGen cg, ConstantPoolGen cp) {
        for (String jComponentName : classReplacementMapping.keySet()) {
            int jComponentClassConstantPosition = cp.lookupClass(jComponentName);
            if (jComponentClassConstantPosition == -1) continue;
            cp.addClass((String)classReplacementMapping.get((Object)jComponentName));
        }
        if (classReplacementMapping.containsKey((Object)cg.getSuperclassName())) {
            cg.setSuperclassName((String)classReplacementMapping.get((Object)cg.getSuperclassName()));
        }
        for (org.apache.bcel.classfile.Method m : cg.getMethods()) {
            MethodGen mg = new MethodGen(m, clazz.getClassName(), cp);
            InstructionList il = mg.getInstructionList();
            if (il == null) continue;
            boolean dirtyFlag = false;
            for (Instruction instruction : il.getInstructions()) {
                ConstantClass classConstant;
                String referencedClassName;
                CPInstruction i;
                Constant instConstant;
                if (!(instruction instanceof CPInstruction) || !((instConstant = cp.getConstant((i = (CPInstruction)instruction).getIndex())) instanceof ConstantClass) || !classReplacementMapping.containsKey((Object)(referencedClassName = ((String)(classConstant = (ConstantClass)instConstant).getConstantValue(cp.getConstantPool())).replace("/", "."))) || i instanceof INSTANCEOF || i instanceof CHECKCAST) continue;
                String myProxyClassName = (String)classReplacementMapping.get((Object)referencedClassName);
                int myProxyConstantClassPosition = cp.lookupClass(myProxyClassName);
                InstructionHandle handle = ClassLoaderUtil.findInstructionHandle(il, (Instruction)i);
                i.setIndex(myProxyConstantClassPosition);
                handle.setInstruction((Instruction)i);
                dirtyFlag = true;
            }
            if (!dirtyFlag) continue;
            il.setPositions();
            mg.setInstructionList(il);
            mg.setMaxStack();
            mg.setMaxLocals();
            mg.removeLineNumbers();
            cg.replaceMethod(m, mg.getMethod());
            il.dispose();
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream result = this.repoClassLoader.getResourceAsStream(name);
        if (result == null) {
            result = this.getParent().getResourceAsStream(name);
        }
        return result;
    }

    @Override
    public URL getResource(String name) {
        return this.repoClassLoader.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.repoClassLoader.getResources(name);
    }

    @Override
    protected Class<?> findClass(String class_name) throws ClassNotFoundException {
        Class<?> cl;
        byte[] bytes = null;
        if (class_name.indexOf("$$BCEL$$") >= 0) {
            bytes = this.createClass(class_name).getBytes();
        } else {
            try {
                if (this.modRegister.canSkipModification(class_name)) {
                    if (class_name.lastIndexOf(".") > 0) {
                        this.definePackage(class_name.substring(0, class_name.lastIndexOf(".")));
                    }
                    bytes = this.loadClassBytes(class_name);
                } else {
                    JavaClass clazz = this.repository.loadClass(class_name);
                    clazz = this.modifyClass(clazz);
                    this.repository.removeClass(clazz);
                    bytes = clazz.getBytes();
                }
                this.modRegister.notifyClassLoaded(class_name);
            }
            catch (ClassNotFoundException e) {
                Class<?> cl2 = this.findLoadedClass(class_name);
                if (cl2 != null) {
                    return cl2;
                }
                throw new ClassNotFoundException(class_name);
            }
        }
        if (bytes != null) {
            Permissions perms = new Permissions();
            perms.add(SecurityConstants.ALL_PERMISSION);
            String classFilePath = this.repoClassLoader.getResource(class_name.replace('.', '/') + ".class").toExternalForm();
            int jarSeparatorIndex = classFilePath.lastIndexOf(33);
            boolean inJar = classFilePath.startsWith("jar:");
            classFilePath = jarSeparatorIndex > 0 && inJar ? classFilePath.substring(4, jarSeparatorIndex) : classFilePath;
            CodeSource source = null;
            try {
                source = new CodeSource(new URL(classFilePath), new Certificate[0]);
            }
            catch (MalformedURLException e) {
                AppLogger.fatal((String)"Exception resolving code source:", (Object[])new Object[]{e});
            }
            ProtectionDomain allPermDomain = new ProtectionDomain(source, perms);
            cl = this.defineClass(class_name, bytes, 0, bytes.length, allPermDomain);
        } else {
            cl = Class.forName(class_name);
        }
        return cl;
    }

    public byte[] loadClassBytes(String className) throws ClassNotFoundException {
        String classFile = className.replace('.', '/');
        try {
            InputStream is = this.repoClassLoader.getResourceAsStream(classFile + ".class");
            Throwable error = null;
            byte[] result = null;
            try {
                if (is == null) {
                    throw new ClassNotFoundException(className + " not found.");
                }
                result = IOUtils.toByteArray((InputStream)is);
            }
            catch (Throwable e) {
                error = e;
                throw e;
            }
            finally {
                if (is != null) {
                    if (error != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable e) {
                            error.addSuppressed(e);
                        }
                    } else {
                        is.close();
                    }
                }
            }
            return result;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(className + " not found: " + e, e);
        }
    }

    public static boolean isModified(Class<?> c) throws Exception {
        String classFile = c.getName().replace('.', '/');
        InputStream is = c.getClassLoader().getResourceAsStream(classFile + ".class");
        ClassParser parser = new ClassParser(is, c.getName());
        JavaClass javaClass = parser.parse();
        ClassGen cg = new ClassGen(javaClass);
        ConstantPoolGen cp = cg.getConstantPool();
        InstructionFactory f = new InstructionFactory(cg);
        boolean result = SwingClassloader.rerouteMehods(javaClass, cg, cp, f);
        return result;
    }

    static {
        ImmutableBiMap.Builder classBuilder = new ImmutableBiMap.Builder();
        classReplacementMapping = classBuilder.build();
        ImmutableBiMap.Builder methodReplacementBuilder = new ImmutableBiMap.Builder();
        methodReplacementBuilder.put((Object)"java.lang.ClassLoader getSystemClassLoader ()Ljava/lang/ClassLoader;", (Object)"org.webswing.special.RedirectedMethods getSystemClassLoader ()Ljava/lang/ClassLoader;");
        methodReplacementBuilder.put((Object)"java.lang.ClassLoader getPlatformClassLoader ()Ljava/lang/ClassLoader;", (Object)"org.webswing.special.RedirectedMethods getPlatformClassLoader ()Ljava/lang/ClassLoader;");
        methodReplacementBuilder.put((Object)"com.intellij.openapi.util.ClassLoaderUtil getPlatformLoaderParentIfOnJdk9 ()Ljava/lang/ClassLoader;", (Object)"org.webswing.special.RedirectedMethods getPlatformLoaderParentIfOnJdk9 ()Ljava/lang/ClassLoader;");
        methodReplacementBuilder.put((Object)"java.lang.ClassLoader getSystemResource (Ljava/lang/String;)Ljava/net/URL;", (Object)"org.webswing.special.RedirectedMethods getSystemResource (Ljava/lang/String;)Ljava/net/URL;");
        methodReplacementBuilder.put((Object)"java.lang.ClassLoader getSystemResourceAsStream (Ljava/lang/String;)Ljava/io/InputStream;", (Object)"org.webswing.special.RedirectedMethods getSystemResourceAsStream (Ljava/lang/String;)Ljava/io/InputStream;");
        methodReplacementBuilder.put((Object)"java.lang.ClassLoader getSystemResources (Ljava/lang/String;)Ljava/util/Enumeration;", (Object)"org.webswing.special.RedirectedMethods getSystemResources (Ljava/lang/String;)Ljava/util/Enumeration;");
        if (!Boolean.getBoolean("webswing.allowRedirectStdOut")) {
            methodReplacementBuilder.put((Object)"java.lang.System setErr (Ljava/io/PrintStream;)V", (Object)"org.webswing.special.RedirectedMethods setErr (Ljava/io/PrintStream;)V");
            methodReplacementBuilder.put((Object)"java.lang.System setOut (Ljava/io/PrintStream;)V", (Object)"org.webswing.special.RedirectedMethods setOut (Ljava/io/PrintStream;)V");
        }
        methodReplacementBuilder.put((Object)"netscape.javascript.JSObject getWindow (Ljava/applet/Applet;)Lnetscape/javascript/JSObject;", (Object)"org.webswing.toolkit.jslink.WebJSObject getWindow (Ljava/applet/Applet;)Lnetscape/javascript/JSObject;");
        methodReplacementBuilder.put((Object)"javax.swing.JDesktopPane putClientProperty (Ljava/lang/Object;Ljava/lang/Object;)V", (Object)"org.webswing.special.RedirectedMethods putClientProperty (Ljavax/swing/JDesktopPane;Ljava/lang/Object;Ljava/lang/Object;)V");
        if (System.getProperty("webswing.isolatedFs", "").equalsIgnoreCase("true")) {
            methodReplacementBuilder.put((Object)"java.io.File listRoots ()[Ljava/io/File;", (Object)"org.webswing.special.RedirectedMethods listRoots ()[Ljava/io/File;");
        }
        methodReplacementBuilder.put((Object)"javax.print.PrintServiceLookup lookupPrintServices (Ljavax/print/DocFlavor;Ljavax/print/attribute/AttributeSet;)[Ljavax/print/PrintService;", (Object)"org.webswing.special.RedirectedMethods lookupPrintServices (Ljavax/print/DocFlavor;Ljavax/print/attribute/AttributeSet;)[Ljavax/print/PrintService;");
        methodReplacementMapping = methodReplacementBuilder.build();
        ImmutableBiMap.Builder methodOverrideBuilder = new ImmutableBiMap.Builder();
        methodOverrideMapping = methodOverrideBuilder.build();
        try {
            ArrayList<Field> candidates = new ArrayList<Field>();
            for (Field f : URL.class.getDeclaredFields()) {
                if (f.getType() != URLStreamHandler.class) continue;
                candidates.add(f);
            }
            Field f = (Field)candidates.get(0);
            f.setAccessible(true);
            originalJarHandler = (URLStreamHandler)f.get(new URL("jar:file:/sample.jar!/"));
        }
        catch (Throwable t) {
            AppLogger.error((String)"Unable to resolve the original URL stream handler:", (Object[])new Object[]{t});
        }
    }

    private static class FallbackURLClassLoader
    extends URLClassLoader {
        public FallbackURLClassLoader(URL[] urls) {
            super(urls);
        }

        @Override
        public URL findResource(String name) {
            URL unsafe = super.findResource(name);
            if (originalJarHandler != null && unsafe != null && unsafe.getProtocol().startsWith("jar")) {
                try {
                    URL safeurl = new URL(null, unsafe.toString(), originalJarHandler);
                    return safeurl;
                }
                catch (MalformedURLException e) {
                    AppLogger.error((String)("Converting " + unsafe.toString() + " to safe url failed"), (Object[])new Object[]{e});
                }
            }
            return unsafe;
        }
    }
}

