/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.services.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.webswing.ext.services.DataStoreService;
import org.webswing.server.common.datastore.DataStoreModuleWrapper;
import org.webswing.server.common.datastore.WebswingDataStoreConfig;
import org.webswing.server.common.datastore.WebswingDataStoreType;
import org.webswing.server.common.util.ConfigUtil;
import org.webswing.server.common.util.ServerUtil;
import org.webswing.server.common.util.WebswingObjectMapper;
import org.webswing.toolkit.util.Util;
import org.webswing.util.AppLogger;

public class DataStoreServiceImpl
implements DataStoreService {
    private static DataStoreServiceImpl impl;
    private DataStoreModuleWrapper dataStore;
    private Map<String, DataStoreService.FileDescriptor> fileMap = new ConcurrentHashMap<String, DataStoreService.FileDescriptor>();
    private ScheduledExecutorService validatorService = Executors.newSingleThreadScheduledExecutor();

    public static DataStoreServiceImpl getInstance() {
        if (impl == null) {
            impl = new DataStoreServiceImpl();
        }
        return impl;
    }

    public DataStoreServiceImpl() {
        this.init();
    }

    private void init() {
        try {
            String base64Config = Util.getDataStoreConfigString();
            Map config = (Map)WebswingObjectMapper.get().readValue(Base64.getDecoder().decode(base64Config), Map.class);
            WebswingDataStoreConfig dataStoreConfig = (WebswingDataStoreConfig)ConfigUtil.instantiateConfig((Map)config, WebswingDataStoreConfig.class, (Object[])new Object[0]);
            this.dataStore = new DataStoreModuleWrapper(dataStoreConfig);
        }
        catch (Exception e) {
            AppLogger.error((String)"Could not deserialize dataStore config!", (Object[])new Object[]{e});
        }
    }

    public void writeStreamToFile(InputStream is, File file) throws IOException {
        FileUtils.copyInputStreamToFile((InputStream)is, (File)file);
    }

    public InputStream readData(String type, String id) {
        return this.dataStore.readData(type, id);
    }

    public boolean dataExists(String type, String id) {
        return this.dataStore.dataExists(type, id);
    }

    public void storeData(String type, String id, InputStream is, boolean deleteIfExists) throws IOException {
        this.dataStore.storeData(type, id, is, deleteIfExists);
    }

    public boolean registerData(byte[] data, String id, long validForTime, TimeUnit timeUnit, String validForUser, String instanceId, boolean temp) {
        DataStoreService.FileDescriptor fd = new DataStoreService.FileDescriptor(data, id, validForUser);
        return this.registerFile(fd, validForTime, timeUnit, instanceId, temp, false, null);
    }

    public boolean registerFile(File file, String id, long validForTime, TimeUnit timeUnit, String validForUser, String instanceId) {
        DataStoreService.FileDescriptor fd = new DataStoreService.FileDescriptor(file, id, validForUser);
        return this.registerFile(fd, validForTime, timeUnit, instanceId, false, false, null);
    }

    public boolean registerFileWhenReady(File file, String id, long validForTime, TimeUnit timeUnit, String validForUser, String instanceId, String overwriteDetails) {
        DataStoreService.FileDescriptor fd = new DataStoreService.FileDescriptor(file, id, validForUser);
        return this.registerFile(fd, validForTime, timeUnit, instanceId, false, true, overwriteDetails);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerFile(DataStoreService.FileDescriptor fd, long validForTime, TimeUnit timeUnit, String instanceId, boolean temp, boolean waitForFile, String overwriteDetails) {
        fd.waitForFile = true;
        fd.overwriteDetails = overwriteDetails;
        fd.instanceId = instanceId;
        fd.temporary = temp;
        if (this.notifyWaitingForSameFile(fd)) {
            return false;
        }
        Map<String, DataStoreService.FileDescriptor> map = this.fileMap;
        synchronized (map) {
            this.fileMap.put(fd.id, fd);
        }
        if (validForTime > 0L) {
            this.createInvalidationTask(fd, validForTime, timeUnit);
        }
        if (waitForFile) {
            this.createWaitTask(fd);
        } else if (fd.file != null) {
            this.writeFileToDataStore(fd.id, fd.file);
        } else if (fd.data != null) {
            this.writeDataToDataStore(fd.id, fd.data);
        }
        return true;
    }

    private void createWaitTask(final DataStoreService.FileDescriptor fd) {
        fd.waitForFileTask = this.validatorService.scheduleAtFixedRate(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DataStoreService.FileDescriptor fileDescriptor = fd;
                synchronized (fileDescriptor) {
                    String details;
                    if (fd.file != null && fd.file.exists() && !(details = fd.file.length() + "|" + fd.file.lastModified()).equals(fd.overwriteDetails)) {
                        if (details.equals(fd.lastFileAttributes)) {
                            if (!ServerUtil.isFileLocked((File)fd.file)) {
                                fd.waitForFile = false;
                                DataStoreServiceImpl.this.writeFileToDataStore(fd.id, fd.file);
                                fd.waitForFileTask.cancel(false);
                            }
                        } else {
                            fd.lastFileAttributes = details;
                        }
                    }
                }
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    private void createInvalidationTask(final DataStoreService.FileDescriptor fd, long validForTime, TimeUnit timeUnit) {
        ScheduledFuture<?> invalidateTask;
        fd.invalidateScheduleTask = invalidateTask = this.validatorService.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map map = DataStoreServiceImpl.this.fileMap;
                synchronized (map) {
                    DataStoreServiceImpl.this.fileMap.remove(fd.id);
                }
                if (fd.temporary) {
                    try {
                        DataStoreServiceImpl.this.dataStore.deleteData(WebswingDataStoreType.transfer.name(), fd.id);
                    }
                    catch (IOException e) {
                        AppLogger.error((String)("Failed to delete file [" + fd.id + "] from data store!"), (Object[])new Object[]{e});
                    }
                    if (fd.file != null) {
                        fd.file.delete();
                    }
                }
            }
        }, validForTime, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyWaitingForSameFile(DataStoreService.FileDescriptor newFd) {
        Map<String, DataStoreService.FileDescriptor> map = this.fileMap;
        synchronized (map) {
            for (String id : this.fileMap.keySet()) {
                DataStoreService.FileDescriptor fd = this.fileMap.get(id);
                if (fd.file == null || newFd.file == null || !fd.instanceId.equals(newFd.instanceId) || !fd.userId.equals(newFd.userId) || !fd.file.equals(newFd.file) || !fd.waitForFile) continue;
                DataStoreService.FileDescriptor fileDescriptor = fd;
                synchronized (fileDescriptor) {
                    fd.waitForFile = false;
                    this.writeFileToDataStore(id, fd.file);
                    if (fd.waitForFileTask != null) {
                        fd.waitForFileTask.cancel(false);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private void writeFileToDataStore(String id, File file) {
        try (FileInputStream is = new FileInputStream(file);){
            this.dataStore.storeData(WebswingDataStoreType.transfer.name(), id, (InputStream)is, true);
        }
        catch (Exception e) {
            AppLogger.error((String)("Error while storing file [" + id + "] to data store!"), (Object[])new Object[]{e});
        }
    }

    private void writeDataToDataStore(String id, byte[] data) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(data);){
            this.dataStore.storeData(WebswingDataStoreType.transfer.name(), id, (InputStream)is, true);
        }
        catch (Exception e) {
            AppLogger.error((String)("Error while storing file data [" + id + "] to data store!"), (Object[])new Object[]{e});
        }
    }
}

