/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.services.impl;

import com.objectplanet.image.PngEncoder;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIORegistry;
import org.apache.commons.codec.binary.Base64;
import org.webswing.common.WindowDecoratorTheme;
import org.webswing.ext.services.ImageService;
import org.webswing.toolkit.util.Util;
import org.webswing.util.AppLogger;

public class ImageServiceImpl
implements ImageService {
    private static ImageServiceImpl impl;
    private Map<Integer, PngEncoder> encoders;
    private ByteArrayOutputStream encoderBuffer = new ByteArrayOutputStream();
    private WindowDecoratorTheme windowDecorationTheme;

    public static ImageServiceImpl getInstance() {
        if (impl == null) {
            impl = new ImageServiceImpl();
        }
        return impl;
    }

    public ImageServiceImpl() {
        try {
            ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            IIORegistry.getDefaultInstance().registerApplicationClasspathSpis();
            Thread.currentThread().setContextClassLoader(currentContextClassLoader);
            this.encoders = new HashMap<Integer, PngEncoder>();
        }
        catch (Exception e) {
            AppLogger.warn((String)"ImageService:Library for fast image encoding not found. Download the library from http://objectplanet.com/pngencoder/", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPngImage(BufferedImage image) {
        try {
            PngEncoder encoder = this.getEncoder(image);
            if (encoder != null) {
                byte[] result;
                ByteArrayOutputStream byteArrayOutputStream = this.encoderBuffer;
                synchronized (byteArrayOutputStream) {
                    encoder.encode((Image)image, (OutputStream)this.encoderBuffer);
                    result = this.encoderBuffer.toByteArray();
                    this.encoderBuffer.reset();
                }
                return result;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", baos);
            return baos.toByteArray();
        }
        catch (IOException e) {
            AppLogger.error((String)("ImageService:Writing image interrupted:" + e.getMessage()), (Object[])new Object[]{e});
            return null;
        }
    }

    public PngEncoder getEncoder(BufferedImage image) {
        int type;
        switch (image.getType()) {
            case 12: 
            case 13: {
                type = image.getColorModel().hasAlpha() ? 5 : 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                type = image.getColorModel().hasAlpha() ? 6 : 2;
                break;
            }
            default: {
                return null;
            }
        }
        PngEncoder encoder = this.encoders.get(type);
        if (encoder == null) {
            encoder = new PngEncoder(type, 1);
            this.encoders.put(type, encoder);
        }
        return encoder;
    }

    public WindowDecoratorTheme getWindowDecorationTheme() {
        if (this.windowDecorationTheme == null) {
            this.windowDecorationTheme = (WindowDecoratorTheme)Util.instantiateClass(WindowDecoratorTheme.class, (String)"org.webswing.window.theme.impl", (String)"org.webswing.theme.DefaultWindowDecoratorTheme", (ClassLoader)ImageServiceImpl.class.getClassLoader());
            if (this.windowDecorationTheme == null) {
                System.exit(1);
            }
        }
        return this.windowDecorationTheme;
    }

    public Image readFromDataUrl(String dataUrl) {
        String encodingPrefix = "base64,";
        int contentStartIndex = dataUrl.indexOf(encodingPrefix) + encodingPrefix.length();
        byte[] imageData = Base64.decodeBase64((String)dataUrl.substring(contentStartIndex));
        BufferedImage inputImage = null;
        try {
            inputImage = ImageIO.read(new ByteArrayInputStream(imageData));
        }
        catch (IOException e) {
            AppLogger.error((String)"ImageService: reading image from dataUrl failed", (Object[])new Object[]{e});
        }
        return inputImage;
    }
}

