/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.services.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Component;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.webswing.ext.services.ServerConnectionService;
import org.webswing.model.SyncObjectResponse;
import org.webswing.model.app.in.ServerToAppFrameMsgIn;
import org.webswing.model.app.out.AppToServerFrameMsgOut;
import org.webswing.model.appframe.in.AppFrameMsgIn;
import org.webswing.model.appframe.out.AccessibilityMsgOut;
import org.webswing.model.appframe.out.AppFrameMsgOut;
import org.webswing.services.impl.connection.ServerConnection;
import org.webswing.services.impl.connection.impl.AppWebsocketConnectionImpl;
import org.webswing.toolkit.util.Util;
import org.webswing.util.AccessibilityUtil;
import org.webswing.util.AppLogger;
import org.webswing.util.ClassLoaderUtil;
import org.webswing.util.ProtoMapper;

public class ServerConnectionServiceImpl
implements ServerConnectionService,
ServerConnection.MessageListener {
    private static ServerConnectionServiceImpl impl;
    private ProtoMapper protoMapper = new ProtoMapper("org.webswing.model.appframe.proto.AppFrameProtoOut", "org.webswing.model.appframe.proto.AppFrameProtoIn", ClassLoaderUtil.getServiceClassLoader());
    private ServerConnection connection;
    private AtomicBoolean closed = new AtomicBoolean(false);
    private List<QueuedMsg> startupMsgQueue = Collections.synchronizedList(new ArrayList());
    private String serverUrl = System.getProperty("webswing.websocketUrl", "");

    public static ServerConnectionServiceImpl getInstance() {
        if (impl == null) {
            impl = new ServerConnectionServiceImpl();
        }
        return impl;
    }

    public ServerConnectionServiceImpl() {
        this.connection = new AppWebsocketConnectionImpl();
        AccessibilityUtil.registerAccessibilityListeners();
    }

    public void initialize() {
        this.initConnection(false);
        Util.getWebToolkit().addStartupListener(() -> {
            if (!this.startupMsgQueue.isEmpty()) {
                AppLogger.info((String)("Dispatching " + this.startupMsgQueue.size() + " queued messages."), (Object[])new Object[0]);
                this.startupMsgQueue.stream().forEach(qm -> this.onMessage(((QueuedMsg)qm).msg));
                this.startupMsgQueue.clear();
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                Util.getWebToolkit().stopRecording();
            }
            catch (Exception sre) {
                sre.printStackTrace();
            }
            this.disconnect();
        }));
    }

    private void initConnection(boolean reconnect) {
        try {
            this.serverUrl = this.serverUrl + "?instanceId=" + System.getProperty("webswing.clientId") + "&sessionPoolId=" + System.getProperty("webswing.sessionpool.id") + "&reconnect=" + reconnect;
            this.connection.initialize(this.serverUrl, this);
            this.closed.set(false);
        }
        catch (Exception e) {
            AppLogger.error((String)"Exiting application because it could not connect to server", (Object[])new Object[]{e});
            System.exit(1);
        }
    }

    public void reconnect(String reconnectUrl) {
        this.disconnect("reconnect");
        this.serverUrl = reconnectUrl;
        this.initConnection(true);
    }

    private void disconnect() {
        this.disconnect(null);
    }

    private void disconnect(String reason) {
        try {
            this.connection.close(reason);
        }
        catch (Exception e) {
            AppLogger.info((String)"Disconnecting from Server failed.", (Object[])new Object[]{e.getMessage()});
        }
        finally {
            this.closed.set(true);
        }
    }

    public void sendObject(AppToServerFrameMsgOut msgOut, AppFrameMsgOut frame) {
        if (!this.closed.get()) {
            try {
                if (frame != null) {
                    try {
                        msgOut.setAppFrameMsgOut(this.protoMapper.encodeProto((Serializable)frame));
                    }
                    catch (IOException e) {
                        AppLogger.error((String)"Could not encode proto!", (Object[])new Object[]{e});
                    }
                }
                this.connection.sendMessage(msgOut);
            }
            catch (Exception e) {
                AppLogger.error((String)"ServerConnectionService.sendJsonObject", (Object[])new Object[]{e});
            }
        }
    }

    public SyncObjectResponse sendObjectSync(AppToServerFrameMsgOut msgOut, AppFrameMsgOut frame, String correlationId) throws Exception {
        if (!this.closed.get()) {
            try {
                if (frame != null) {
                    try {
                        msgOut.setAppFrameMsgOut(this.protoMapper.encodeProto((Serializable)frame));
                    }
                    catch (IOException e) {
                        AppLogger.error((String)"Could not encode proto!", (Object[])new Object[]{e});
                        throw e;
                    }
                }
                return this.connection.sendMessageSync(msgOut, correlationId);
            }
            catch (Exception e) {
                AppLogger.error((String)"ServerConnectionService.sendJsonObject", (Object[])new Object[]{e});
                throw e;
            }
        }
        throw new Exception("Failed to send request. Servie was disconnected.");
    }

    public AccessibilityMsgOut getAccessibilityInfo() {
        return AccessibilityUtil.getAccessibilityInfo();
    }

    public AccessibilityMsgOut getAccessibilityInfo(Component c, int x, int y) {
        return AccessibilityUtil.getAccessibilityInfo(c, x, y);
    }

    @Override
    public void onMessage(ServerToAppFrameMsgIn msgIn) {
        if (Util.getWebToolkit().getEventDispatcher() == null) {
            this.startupMsgQueue.add(new QueuedMsg(msgIn));
            return;
        }
        AppFrameMsgIn frame = null;
        if (msgIn.getAppFrameMsgIn() != null) {
            try {
                frame = this.protoMapper.decodeProto(msgIn.getAppFrameMsgIn(), AppFrameMsgIn.class);
            }
            catch (IOException e) {
                AppLogger.error((String)"Could not encode proto!", (Object[])new Object[]{e});
            }
        }
        if (msgIn.getApiCallResult() != null && msgIn.getApiCallResult().getCorrelationId() != null || frame != null && frame.getJsResponse() != null && frame.getJsResponse().getCorrelationId() != null) {
            this.connection.handleSyncMessageResult(msgIn, frame);
            return;
        }
        Util.getWebToolkit().getEventDispatcher().onMessage(msgIn, frame);
    }

    public Map<String, Serializable> deserializeUserAttributes(byte[] data) throws IOException {
        if (data == null) {
            return null;
        }
        return (Map)new ObjectMapper().readValue(data, (TypeReference)new TypeReference<Map<String, Serializable>>(){});
    }

    private static class QueuedMsg {
        private ServerToAppFrameMsgIn msg;

        public QueuedMsg(ServerToAppFrameMsgIn msg) {
            this.msg = msg;
        }
    }
}

