/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.util;

import com.sun.java.accessibility.util.AccessibilityEventMonitor;
import com.sun.java.accessibility.util.Translator;
import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.FocusManager;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.webswing.model.appframe.out.AccessibilityHierarchyMsgOut;
import org.webswing.model.appframe.out.AccessibilityMsgOut;
import org.webswing.model.appframe.out.FileDialogEventMsgOut;
import org.webswing.toolkit.util.Util;

public class AccessibilityUtil {
    private static Map<AccessibleRole, String> accessibleRoleMap = new HashMap<AccessibleRole, String>();
    private static Map<AccessibleState, String> accessibleStateMap = new HashMap<AccessibleState, String>();
    private static List<String> allowedHierarchyRoles = new ArrayList<String>();
    private static List<String> allowedNoTextHierarchyRoles = new ArrayList<String>();

    public static void registerAccessibilityListeners() {
        FocusManager.getCurrentManager().addPropertyChangeListener("focusOwner", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Util.getWebToolkit().getPaintDispatcher().notifyAccessibilityInfoUpdate();
            }
        });
        AccessibilityEventMonitor.addPropertyChangeListener(evt -> {
            switch (evt.getPropertyName()) {
                case "AccessibleState": 
                case "AccessibleSelection": 
                case "AccessibleValue": 
                case "AccessibleActiveDescendant": {
                    Util.getWebToolkit().getPaintDispatcher().notifyAccessibilityInfoUpdate();
                }
            }
        });
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                Util.getWebToolkit().getPaintDispatcher().notifyAccessibilityInfoUpdate();
            }
        }, 4L);
    }

    public static AccessibilityMsgOut getAccessibilityInfo() {
        Component c = FocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        Accessible a = null;
        if (c != null) {
            a = c instanceof Accessible ? (Accessible)((Object)c) : Translator.getAccessible(c);
        }
        return AccessibilityUtil.getAccessibilityInfo(a);
    }

    public static AccessibilityMsgOut getAccessibilityInfo(Component c, int x, int y) {
        Point p = new Point(x, y);
        SwingUtilities.convertPointFromScreen(p, c);
        Component deepC = SwingUtilities.getDeepestComponentAt(c, p.x, p.y);
        Accessible a = null;
        if (deepC != null) {
            a = deepC instanceof Accessible ? (Accessible)((Object)deepC) : Translator.getAccessible(deepC);
        }
        return AccessibilityUtil.getAccessibilityInfo(a);
    }

    private static AccessibilityMsgOut getAccessibilityInfo(Accessible accessible) {
        AccessibleValue value;
        JTable table;
        TreePath path;
        JTree tree;
        int index;
        JList list;
        Object[] members;
        Document doc;
        View view;
        String tooltip;
        AccessibleContext ctx;
        JDialog dialog;
        JOptionPane optionPane;
        FileDialogEventMsgOut.FileDialogEventType fdet;
        JFileChooser fc;
        Window w;
        Accessible a = accessible;
        AccessibilityMsgOut result = new AccessibilityMsgOut();
        if (a == null) {
            return null;
        }
        if (AccessibilityUtil.isJavaFXWindow(a)) {
            return null;
        }
        if (a instanceof Component && (w = SwingUtilities.getWindowAncestor((Component)((Object)a))) != null && (fc = Util.discoverFileChooser((Window)w)) != null && ((fdet = Util.getFileChooserEventType((JFileChooser)fc)) == FileDialogEventMsgOut.FileDialogEventType.AutoSave || fdet == FileDialogEventMsgOut.FileDialogEventType.AutoUpload)) {
            return null;
        }
        if (a instanceof JTable || a instanceof JTextArea) {
            KeyStroke shiftEscapeStroke;
            HashSet<AWTKeyStroke> backwardKeys;
            KeyStroke escapeStroke;
            Component c = (Component)((Object)a);
            HashSet<AWTKeyStroke> forwardKeys = new HashSet<AWTKeyStroke>(c.getFocusTraversalKeys(0));
            if (!forwardKeys.contains(escapeStroke = KeyStroke.getKeyStroke(27, 0))) {
                forwardKeys.add(escapeStroke);
                c.setFocusTraversalKeys(0, forwardKeys);
            }
            if (!(backwardKeys = new HashSet<AWTKeyStroke>(c.getFocusTraversalKeys(1))).contains(shiftEscapeStroke = KeyStroke.getKeyStroke(27, 64))) {
                backwardKeys.add(shiftEscapeStroke);
                c.setFocusTraversalKeys(1, backwardKeys);
            }
        }
        if (a instanceof JRootPane || a instanceof JPopupMenu) {
            MenuElement[] me = MenuSelectionManager.defaultManager().getSelectedPath();
            if (me != null && me.length > 0 && me[me.length - 1] instanceof Accessible) {
                a = (Accessible)((Object)me[me.length - 1]);
            }
            if (a instanceof JPopupMenu && ((JPopupMenu)a).getInvoker() instanceof JMenu) {
                a = (JMenu)((JPopupMenu)a).getInvoker();
            }
        }
        JDialog optionPaneDialog = null;
        if (a instanceof JDialog && (optionPane = AccessibilityUtil.findOptionPane((dialog = (JDialog)a).getContentPane())) != null) {
            a = optionPane;
            optionPaneDialog = dialog;
        }
        if ((ctx = a.getAccessibleContext()) == null) {
            return null;
        }
        String description = AccessibilityUtil.getAccessibleDescription(ctx);
        String id = System.identityHashCode(a) + "";
        result.setText(ctx.getAccessibleName());
        String ariaRole = AccessibilityUtil.toAriaRole(ctx.getAccessibleRole());
        if (ariaRole == null) {
            return null;
        }
        result.setRole(ariaRole);
        AccessibleStateSet stateSet = ctx.getAccessibleStateSet();
        if (stateSet != null) {
            ArrayList<String> states = new ArrayList<String>();
            for (AccessibleState state : stateSet.toArray()) {
                String ariaState = AccessibilityUtil.toAriaState(state);
                if (ariaState == null) continue;
                states.add(ariaState);
            }
            result.setStates(states);
        }
        if (a instanceof Component) {
            AccessibilityUtil.handleComponent(result, (Component)((Object)a));
        }
        if (a instanceof JComponent && (tooltip = ((JComponent)((Object)a)).getToolTipText()) != null && tooltip.trim().length() > 0) {
            result.setTooltip(tooltip);
        }
        if (ctx.getAccessibleRole() == AccessibleRole.PANEL && StringUtils.isBlank((CharSequence)result.getText())) {
            return null;
        }
        if (a instanceof JOptionPane) {
            JOptionPane optionPane2 = (JOptionPane)a;
            if (optionPane2.getMessage() instanceof String) {
                description = (String)optionPane2.getMessage();
            } else if (optionPane2.getMessage() instanceof Accessible) {
                description = ((Accessible)optionPane2.getMessage()).getAccessibleContext().getAccessibleName();
            }
            if (optionPaneDialog != null) {
                result.setText(optionPaneDialog.getTitle());
            } else {
                Window w2 = SwingUtilities.getWindowAncestor(optionPane2);
                if (w2 != null && w2 instanceof Dialog) {
                    result.setText(((Dialog)w2).getTitle());
                }
            }
        }
        if (a instanceof JLabel && (view = (View)((JLabel)a).getClientProperty("html")) != null) {
            doc = view.getDocument();
            try {
                result.setText(doc.getText(0, doc.getLength()));
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        if (a instanceof JTextComponent) {
            AccessibleText at;
            JTextComponent textComponent = (JTextComponent)a;
            doc = textComponent.getDocument();
            try {
                result.setText(doc.getText(0, doc.getLength()));
            }
            catch (BadLocationException e) {
                // empty catch block
            }
            if (ctx.getAccessibleRole() == AccessibleRole.PASSWORD_TEXT) {
                result.setPassword(true);
            }
            if ((at = ctx.getAccessibleText()) != null && at.getSelectionStart() != -1 && at.getSelectionEnd() != -1) {
                result.setSelstart(at.getSelectionStart());
                result.setSelend(at.getSelectionEnd());
            }
        }
        if (a instanceof JTextArea) {
            int height = result.getHeight();
            int rowHeight = ((JTextArea)a).getFontMetrics(((JTextArea)a).getFont()).getHeight();
            result.setRowheight(rowHeight);
            result.setRows(height / rowHeight);
        }
        if (a instanceof JEditorPane) {
            JEditorPane editor = (JEditorPane)a;
            if (ctx.getAccessibleDescription() != null && ctx.getAccessibleDescription().equals(editor.getContentType())) {
                description = null;
            }
        }
        if (ctx.getAccessibleRole() == AccessibleRole.TOGGLE_BUTTON) {
            result.setToggle(true);
        }
        if (ctx.getAccessibleRole() == AccessibleRole.RADIO_BUTTON && ctx.getAccessibleRelationSet().contains(AccessibleRelation.MEMBER_OF) && (members = ctx.getAccessibleRelationSet().get(AccessibleRelation.MEMBER_OF).getTarget()) != null) {
            result.setSize(members.length);
            result.setPosition(ArrayUtils.indexOf((Object[])members, (Object)a) + 1);
        }
        if (ctx.getAccessibleRole() == AccessibleRole.COMBO_BOX && a instanceof JComboBox) {
            JComboBox combo = (JComboBox)a;
            result.setSize(combo.getItemCount());
            if (combo.getSelectedIndex() > -1) {
                result.setPosition(combo.getSelectedIndex() + 1);
            }
            if (combo.getSelectedItem() != null) {
                String valueText = null;
                Accessible comboA = ctx.getAccessibleSelection().getAccessibleSelection(0);
                if (comboA != null) {
                    int index2;
                    JList list2;
                    if (comboA.getAccessibleContext().getAccessibleParent() instanceof JList && (list2 = (JList)comboA.getAccessibleContext().getAccessibleParent()).getModel() != null && (index2 = list2.getLeadSelectionIndex()) >= 0) {
                        Component listC;
                        ListCellRenderer renderer = list2.getCellRenderer();
                        Object value2 = list2.getModel().getElementAt(index2);
                        if (renderer != null && value2 != null && (listC = list2.getCellRenderer().getListCellRendererComponent(list2, value2, index2, list2.isSelectedIndex(index2), true)) != null) {
                            if (listC instanceof JLabel) {
                                valueText = AccessibilityUtil.getTextFromLabel((JLabel)listC);
                            }
                            if (listC instanceof Accessible && listC.getAccessibleContext() != null) {
                                if (valueText == null) {
                                    valueText = listC.getAccessibleContext().getAccessibleName();
                                }
                                description = AccessibilityUtil.getAccessibleDescription(listC.getAccessibleContext());
                            }
                        }
                    }
                    if (valueText == null) {
                        valueText = comboA.getAccessibleContext().getAccessibleName();
                    }
                }
                if (valueText == null) {
                    valueText = combo.getSelectedItem().toString();
                }
                result.setValue(valueText);
            }
        }
        if (ctx.getAccessibleRole() == AccessibleRole.PAGE_TAB_LIST && a instanceof JTabbedPane) {
            JTabbedPane tabPane = (JTabbedPane)a;
            result.setSize(tabPane.getTabCount());
            result.setPosition(tabPane.getSelectedIndex() + 1);
        }
        if (ctx.getAccessibleRole() == AccessibleRole.PAGE_TAB && ctx.getAccessibleParent() instanceof JTabbedPane) {
            JTabbedPane tabPane = (JTabbedPane)ctx.getAccessibleParent();
            result.setSize(tabPane.getTabCount());
            result.setPosition(ctx.getAccessibleIndexInParent() + 1);
        }
        if (ctx.getAccessibleRole() == AccessibleRole.LIST && a instanceof JList && (list = (JList)a).getModel() != null && (index = list.getLeadSelectionIndex()) >= 0) {
            Component listC;
            result.setRole("listitem");
            result.setSize(list.getModel().getSize());
            result.setPosition(index + 1);
            ListCellRenderer renderer = list.getCellRenderer();
            Object value3 = list.getModel().getElementAt(index);
            String valueText = null;
            if (renderer != null && value3 != null && (listC = list.getCellRenderer().getListCellRendererComponent(list, value3, index, list.isSelectedIndex(index), true)) != null) {
                if (listC instanceof JLabel) {
                    valueText = AccessibilityUtil.getTextFromLabel((JLabel)listC);
                }
                if (listC instanceof Accessible && listC.getAccessibleContext() != null) {
                    if (valueText == null) {
                        valueText = listC.getAccessibleContext().getAccessibleName();
                    }
                    description = AccessibilityUtil.getAccessibleDescription(listC.getAccessibleContext());
                }
            }
            if (valueText == null) {
                valueText = list.getModel().getElementAt(index).toString();
            }
            if (valueText != null) {
                result.setText(valueText);
            }
            if (list.isSelectedIndex(index) && !result.getStates().contains("SELECTED")) {
                result.getStates().add("SELECTED");
            }
        }
        if (ctx.getAccessibleRole() == AccessibleRole.TREE && a instanceof JTree && (tree = (JTree)a).getSelectionModel() != null && tree.getModel() != null && (path = tree.getSelectionModel().getLeadSelectionPath()) != null) {
            result.setRole("treeitem");
            if (path.getLastPathComponent() instanceof TreeNode) {
                TreeNode node = (TreeNode)path.getLastPathComponent();
                if (node.getParent() != null) {
                    result.setLevel(path.getPath().length);
                    result.setSize(node.getParent().getChildCount());
                    result.setPosition(node.getParent().getIndex(node) + 1);
                } else {
                    result.setLevel(1);
                    result.setSize(1);
                    result.setPosition(1);
                }
                ArrayList<String> states = new ArrayList<String>();
                if (tree.isPathEditable(path)) {
                    states.add("EDITABLE");
                }
                if (tree.isPathSelected(path)) {
                    states.add("SELECTED");
                }
                if (tree.isExpanded(path)) {
                    states.add("EXPANDED");
                }
                if (tree.getSelectionModel().getSelectionMode() != 1) {
                    states.add("MULTISELECTABLE");
                }
                states.add("ENABLED");
                result.setStates(states);
                result.setText(node.toString());
            }
        }
        if (ctx.getAccessibleRole() == AccessibleRole.TABLE && a instanceof JTable && (table = (JTable)a).getSelectionModel() != null && table.getColumnModel() != null && table.getColumnModel().getSelectionModel() != null) {
            int rowIndex = table.getSelectionModel().getLeadSelectionIndex();
            int colIndex = table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (rowIndex >= 0 && colIndex >= 0) {
                Component cellC;
                result.setRole("gridcell");
                result.setColindex(colIndex + 1);
                result.setRowindex(rowIndex + 1);
                result.setRowcount(table.getRowCount());
                result.setColcount(table.getColumnCount());
                Object headerValue = table.getColumnModel().getColumn(colIndex).getHeaderValue();
                if (headerValue != null) {
                    result.setColumnheader(headerValue.toString());
                }
                TableCellRenderer renderer = table.getCellRenderer(rowIndex, colIndex);
                Object value4 = table.getValueAt(rowIndex, colIndex);
                if (renderer != null && value4 != null && (cellC = renderer.getTableCellRendererComponent(table, value4, table.isCellSelected(rowIndex, colIndex), true, rowIndex, colIndex)) != null) {
                    String text = null;
                    if (cellC instanceof JLabel) {
                        text = AccessibilityUtil.getTextFromLabel((JLabel)cellC);
                    }
                    if (cellC instanceof Accessible && cellC.getAccessibleContext() != null) {
                        if (text == null) {
                            text = cellC.getAccessibleContext().getAccessibleName();
                        }
                        description = AccessibilityUtil.getAccessibleDescription(cellC.getAccessibleContext());
                    }
                    if (text != null) {
                        result.setText(text);
                    }
                }
                if (table.isCellSelected(rowIndex, colIndex)) {
                    if (!result.getStates().contains("SELECTED")) {
                        result.getStates().add("SELECTED");
                    }
                } else {
                    result.getStates().remove("SELECTED");
                }
                if (table.getSelectionModel().getSelectionMode() != 0) {
                    result.getStates().add("MULTISELECTABLE");
                }
                if (table.isCellEditable(rowIndex, colIndex)) {
                    result.getStates().add("EDITABLE");
                }
            }
        }
        if (ctx.getAccessibleRole() == AccessibleRole.MENU_ITEM && a instanceof JMenuItem) {
            JMenuItem menuItem = (JMenuItem)a;
            Container parent = null;
            if (menuItem.getParent() instanceof JPopupMenu) {
                Component invoker = ((JPopupMenu)menuItem.getParent()).getInvoker();
                if (invoker instanceof JMenu) {
                    parent = (JMenu)invoker;
                    result.setSize(((JMenu)invoker).getMenuComponentCount());
                } else {
                    parent = menuItem.getParent();
                    result.setSize(((JPopupMenu)menuItem.getParent()).getComponentCount());
                }
            }
            if (parent != null) {
                id = System.identityHashCode(parent) + "";
            }
            if (a instanceof JCheckBoxMenuItem) {
                result.setRole("menuitemcheckbox");
            }
            if (a instanceof JRadioButtonMenuItem) {
                result.setRole("menuitemradio");
            }
            result.setPosition(ctx.getAccessibleIndexInParent() + 1);
        }
        if ((value = ctx.getAccessibleValue()) != null) {
            if (value.getCurrentAccessibleValue() != null) {
                result.setVal(value.getCurrentAccessibleValue().intValue());
            }
            if (value.getMaximumAccessibleValue() != null) {
                result.setMax(value.getMaximumAccessibleValue().intValue());
            }
            if (value.getMinimumAccessibleValue() != null) {
                result.setMin(value.getMinimumAccessibleValue().intValue());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)description)) {
            result.setDescription(description);
        }
        if (StringUtils.isNotBlank((CharSequence)id)) {
            result.setId(id);
        }
        ArrayList<AccessibilityHierarchyMsgOut> hierarchy = new ArrayList<AccessibilityHierarchyMsgOut>();
        AccessibilityUtil.resolveHierarchy(ctx.getAccessibleParent(), hierarchy);
        result.setHierarchy(hierarchy);
        return result;
    }

    private static boolean isJavaFXWindow(Accessible a) {
        Window w = null;
        if (a instanceof Window && Util.isFXWindow((Window)((Window)a))) {
            w = (Window)a;
        } else if (a instanceof Component) {
            w = SwingUtilities.getWindowAncestor((Component)((Object)a));
        }
        return w != null && Util.isFXWindow((Window)w);
    }

    private static String getTextFromLabel(JLabel label) {
        View view = (View)label.getClientProperty("html");
        if (view != null) {
            Document doc = view.getDocument();
            try {
                return doc.getText(0, doc.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void resolveHierarchy(Accessible a, List<AccessibilityHierarchyMsgOut> hierarchy) {
        JTabbedPane tabPane;
        if (a == null || a.getAccessibleContext() == null) {
            return;
        }
        AccessibleContext ctx = a.getAccessibleContext();
        AccessibilityUtil.resolveHierarchy(ctx.getAccessibleParent(), hierarchy);
        String id = System.identityHashCode(a) + "";
        String role = AccessibilityUtil.toAriaRole(ctx.getAccessibleRole());
        String text = ctx.getAccessibleName();
        Integer position = null;
        Integer size = null;
        if (ctx.getAccessibleRole() == AccessibleRole.PAGE_TAB_LIST && a instanceof JTabbedPane) {
            tabPane = (JTabbedPane)a;
            position = tabPane.getSelectedIndex() + 1;
            size = tabPane.getTabCount();
        }
        if (ctx.getAccessibleRole() == AccessibleRole.PAGE_TAB && ctx.getAccessibleParent() instanceof JTabbedPane) {
            tabPane = (JTabbedPane)ctx.getAccessibleParent();
            position = ctx.getAccessibleIndexInParent() + 1;
            size = tabPane.getTabCount();
        }
        if (role != null && allowedHierarchyRoles.contains(role) && (StringUtils.isNotBlank((CharSequence)text) || allowedNoTextHierarchyRoles.contains(role))) {
            AccessibilityHierarchyMsgOut msg = new AccessibilityHierarchyMsgOut(id, role, text);
            if (position != null && size != null) {
                msg.setPosition(position);
                msg.setSize(size);
            }
            hierarchy.add(msg);
        }
    }

    private static void handleComponent(AccessibilityMsgOut result, Component a) {
        Component c = a;
        try {
            result.setScreenX(c.getLocationOnScreen().x);
            result.setScreenY(c.getLocationOnScreen().y);
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
        Dimension dim = AccessibilityUtil.getComponentDimensions(c);
        result.setHeight(dim.height);
        result.setWidth(dim.width);
    }

    private static JOptionPane findOptionPane(Container contentPane) {
        for (Component c : contentPane.getComponents()) {
            if (!(c instanceof JOptionPane)) continue;
            return (JOptionPane)c;
        }
        return null;
    }

    private static Dimension getComponentDimensions(Component c) {
        int minHeight = c.getHeight();
        int minWidth = c.getWidth();
        for (Container parent = c.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getHeight() < minHeight) {
                minHeight = parent.getHeight();
            }
            if (parent.getWidth() >= minWidth) continue;
            minWidth = parent.getWidth();
        }
        return new Dimension(minWidth, minHeight);
    }

    private static String getAccessibleDescription(AccessibleContext ctx) {
        String description;
        Object[] target;
        if (ctx.getAccessibleDescription() != null) {
            return ctx.getAccessibleDescription();
        }
        if (ctx.getAccessibleRelationSet().contains(AccessibleRelation.LABELED_BY) && (target = ctx.getAccessibleRelationSet().get(AccessibleRelation.LABELED_BY).getTarget()) != null && target.length > 0 && target[0] instanceof Accessible && StringUtils.isNotBlank((CharSequence)(description = ((Accessible)target[0]).getAccessibleContext().getAccessibleName()))) {
            return description;
        }
        return null;
    }

    private static String toAriaRole(AccessibleRole accessibleRole) {
        if (accessibleRole == null) {
            return null;
        }
        return accessibleRoleMap.get(accessibleRole);
    }

    private static String toAriaState(AccessibleState state) {
        if (state == null) {
            return null;
        }
        return accessibleStateMap.get(state);
    }

    static {
        accessibleRoleMap.put(AccessibleRole.PUSH_BUTTON, "button");
        accessibleRoleMap.put(AccessibleRole.TOGGLE_BUTTON, "button");
        accessibleRoleMap.put(AccessibleRole.CHECK_BOX, "checkbox");
        accessibleRoleMap.put(AccessibleRole.COMBO_BOX, "combobox");
        accessibleRoleMap.put(AccessibleRole.RADIO_BUTTON, "radio");
        accessibleRoleMap.put(AccessibleRole.ICON, "img");
        accessibleRoleMap.put(AccessibleRole.TOOL_TIP, "tooltip");
        accessibleRoleMap.put(AccessibleRole.PROGRESS_BAR, "progressbar");
        accessibleRoleMap.put(AccessibleRole.TREE, "tree");
        accessibleRoleMap.put(AccessibleRole.SCROLL_BAR, "scrollbar");
        accessibleRoleMap.put(AccessibleRole.LIST, "list");
        accessibleRoleMap.put(AccessibleRole.SLIDER, "slider");
        accessibleRoleMap.put(AccessibleRole.TABLE, "table");
        accessibleRoleMap.put(AccessibleRole.MENU_BAR, "menubar");
        accessibleRoleMap.put(AccessibleRole.MENU_ITEM, "menuitem");
        accessibleRoleMap.put(AccessibleRole.PAGE_TAB_LIST, "tablist");
        accessibleRoleMap.put(AccessibleRole.PAGE_TAB, "tab");
        accessibleRoleMap.put(AccessibleRole.DIALOG, "dialog");
        accessibleRoleMap.put(AccessibleRole.FRAME, "dialog");
        accessibleRoleMap.put(AccessibleRole.WINDOW, "dialog");
        accessibleRoleMap.put(AccessibleRole.ALERT, "alertdialog");
        accessibleRoleMap.put(AccessibleRole.MENU, "menu");
        accessibleRoleMap.put(AccessibleRole.POPUP_MENU, "menu");
        accessibleRoleMap.put(AccessibleRole.TEXT, "textbox");
        accessibleRoleMap.put(AccessibleRole.PASSWORD_TEXT, "textbox");
        accessibleRoleMap.put(AccessibleRole.SPIN_BOX, "spinbutton");
        accessibleRoleMap.put(AccessibleRole.PANEL, "group");
        accessibleRoleMap.put(AccessibleRole.LABEL, "label");
        accessibleStateMap.put(AccessibleState.ACTIVE, "ACTIVE");
        accessibleStateMap.put(AccessibleState.ARMED, "ARMED");
        accessibleStateMap.put(AccessibleState.BUSY, "BUSY");
        accessibleStateMap.put(AccessibleState.CHECKED, "CHECKED");
        accessibleStateMap.put(AccessibleState.COLLAPSED, "COLLAPSED");
        accessibleStateMap.put(AccessibleState.EDITABLE, "EDITABLE");
        accessibleStateMap.put(AccessibleState.ENABLED, "ENABLED");
        accessibleStateMap.put(AccessibleState.EXPANDABLE, "EXPANDABLE");
        accessibleStateMap.put(AccessibleState.EXPANDED, "EXPANDED");
        accessibleStateMap.put(AccessibleState.FOCUSABLE, "FOCUSABLE");
        accessibleStateMap.put(AccessibleState.FOCUSED, "FOCUSED");
        accessibleStateMap.put(AccessibleState.HORIZONTAL, "HORIZONTAL");
        accessibleStateMap.put(AccessibleState.ICONIFIED, "ICONIFIED");
        accessibleStateMap.put(AccessibleState.INDETERMINATE, "INDETERMINATE");
        accessibleStateMap.put(AccessibleState.MANAGES_DESCENDANTS, "MANAGES_DESCENDANTS");
        accessibleStateMap.put(AccessibleState.MODAL, "MODAL");
        accessibleStateMap.put(AccessibleState.MULTI_LINE, "MULTI_LINE");
        accessibleStateMap.put(AccessibleState.MULTISELECTABLE, "MULTISELECTABLE");
        accessibleStateMap.put(AccessibleState.OPAQUE, "OPAQUE");
        accessibleStateMap.put(AccessibleState.PRESSED, "PRESSED");
        accessibleStateMap.put(AccessibleState.RESIZABLE, "RESIZABLE");
        accessibleStateMap.put(AccessibleState.SELECTABLE, "SELECTABLE");
        accessibleStateMap.put(AccessibleState.SELECTED, "SELECTED");
        accessibleStateMap.put(AccessibleState.SHOWING, "SHOWING");
        accessibleStateMap.put(AccessibleState.SINGLE_LINE, "SINGLE_LINE");
        accessibleStateMap.put(AccessibleState.TRANSIENT, "TRANSIENT");
        accessibleStateMap.put(AccessibleState.TRUNCATED, "TRUNCATED");
        accessibleStateMap.put(AccessibleState.VERTICAL, "VERTICAL");
        accessibleStateMap.put(AccessibleState.VISIBLE, "VISIBLE");
        allowedHierarchyRoles.addAll(accessibleRoleMap.values());
        allowedHierarchyRoles.remove("tablist");
        allowedNoTextHierarchyRoles.add("dialog");
        allowedNoTextHierarchyRoles.add("alertdialog");
    }
}

