/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.util;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.webswing.classloader.SwingClassLoaderFactory;
import org.webswing.ext.services.DataStoreService;
import org.webswing.ext.services.DirectDrawService;
import org.webswing.ext.services.ImageService;
import org.webswing.ext.services.JsLinkService;
import org.webswing.ext.services.PdfService;
import org.webswing.ext.services.ServerConnectionService;
import org.webswing.ext.services.SwingClassLoaderFactoryService;
import org.webswing.services.impl.DataStoreServiceImpl;
import org.webswing.services.impl.DirectDrawServiceImpl;
import org.webswing.services.impl.ImageServiceImpl;
import org.webswing.services.impl.JPDFWriterPdfServiceImpl;
import org.webswing.services.impl.JsLinkServiceImpl;
import org.webswing.services.impl.PdfServiceImpl;
import org.webswing.services.impl.ServerConnectionServiceImpl;
import org.webswing.toolkit.util.Services;
import org.webswing.util.AppLogger;

public class ClassLoaderUtil {
    private static ClassLoader serviceClassLoader;

    public static void initializeServices() {
        Object pdfService;
        serviceClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoaderUtil.initSystemProperties();
        ImageServiceImpl imageService = ImageServiceImpl.getInstance();
        SwingClassLoaderFactory classloaderService = SwingClassLoaderFactory.getInstance();
        DirectDrawServiceImpl directDrawServiceImpl = DirectDrawServiceImpl.getInstance();
        ServerConnectionServiceImpl serverService = ServerConnectionServiceImpl.getInstance();
        DataStoreServiceImpl dataStoreService = DataStoreServiceImpl.getInstance();
        JsLinkServiceImpl jsLinkService = JsLinkServiceImpl.getInstance();
        try {
            Class.forName("com.qoppa.pdfWriter.PDFDocument");
            pdfService = JPDFWriterPdfServiceImpl.getInstance();
        }
        catch (ClassNotFoundException e) {
            AppLogger.info((String)"JPDFWriter library not found on classpath, fallback to FreeHEP PDF service.", (Object[])new Object[0]);
            pdfService = PdfServiceImpl.getInstance();
        }
        Services.initialize((ImageService)imageService, (PdfService)pdfService, (ServerConnectionService)serverService, (DataStoreService)dataStoreService, (SwingClassLoaderFactoryService)classloaderService, (DirectDrawService)directDrawServiceImpl, (JsLinkService)jsLinkService);
        serverService.initialize();
    }

    public static List<Method> getAllConstructors(JavaClass clazz) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals("<init>")) continue;
            result.add(m);
        }
        return result;
    }

    public static Method getPaintMethod(JavaClass clazz) {
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals("paint") || !m.isPublic() || m.getArgumentTypes().length != 1 || !m.getArgumentTypes()[0].getSignature().equals("Ljava/awt/Graphics;")) continue;
            return m;
        }
        return null;
    }

    public static boolean isSubClassOfJComponent(JavaClass clazz) {
        try {
            for (JavaClass c : clazz.getSuperClasses()) {
                if (!c.getClassName().equals("javax.swing.JComponent")) continue;
                return true;
            }
            return false;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isInPackage(String packageInspected, String[] packagePrefixed) {
        for (String prefix : packagePrefixed) {
            if (packageInspected == null || !packageInspected.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static String[] createArgNames(int number) {
        String[] result = new String[number];
        for (int i = 0; i < number; ++i) {
            result[i] = "arg" + i;
        }
        return result;
    }

    public static InstructionHandle findInstructionHandle(InstructionList il, Instruction i) {
        for (InstructionHandle ih = il.getStart(); ih != null; ih = ih.getNext()) {
            if (!ih.getInstruction().equals((Object)i)) continue;
            return ih;
        }
        return null;
    }

    public static ClassLoader getServiceClassLoader() {
        return serviceClassLoader;
    }

    private static void initSystemProperties() {
        String connectionSecretSerialized = System.getProperty("webswing.connection.secret");
        String connectionSecretDeserialized = new String(Base64.getDecoder().decode(connectionSecretSerialized.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        System.setProperty("webswing.connection.secret", connectionSecretDeserialized);
    }
}

