/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.services.impl;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PageRanges;
import org.freehep.graphicsbase.util.UserProperties;
import org.freehep.graphicsio.PageConstants;
import org.freehep.graphicsio.pdf.PDFGraphics2D;
import org.webswing.ext.services.PdfService;
import org.webswing.toolkit.WebPrinterJobWrapper;
import org.webswing.toolkit.util.DummyGraphics2D;
import org.webswing.toolkit.util.Util;

public class PdfServiceImpl
implements PdfService {
    private static PdfServiceImpl impl;
    private static Graphics2D dummyG;

    public static PdfServiceImpl getInstance() {
        if (impl == null) {
            impl = new PdfServiceImpl();
        }
        return impl;
    }

    public void printToPDF(OutputStream out, Pageable pageable, Printable printable, PrintRequestAttributeSet attribs) throws PrinterException, IOException {
        PageFormat pageFormat = WebPrinterJobWrapper.toPageFormat((PrintRequestAttributeSet)attribs);
        Graphics2D resultPdf = this.createPDFGraphics(out, pageFormat);
        if (printable != null) {
            int i = 0;
            while (this.paintPdf(resultPdf, pageFormat, attribs, printable, i++) != 1) {
            }
        } else if (pageable != null) {
            int no = pageable.getNumberOfPages();
            for (int i = 0; i < no; ++i) {
                PageFormat pageablePageFormat = pageable.getPageFormat(i);
                this.paintPdf(resultPdf, pageablePageFormat != null ? pageablePageFormat : pageFormat, attribs, pageable.getPrintable(i), i);
            }
        }
        this.closePDFGraphics(resultPdf);
    }

    private int paintPdf(Graphics2D resultPdf, PageFormat pageFormat, PrintRequestAttributeSet attribs, Printable printable, int i) throws PrinterException {
        if (this.isInRange(i, attribs)) {
            if (printable != null && printable.print(dummyG, pageFormat, i) != 1) {
                this.startPagePDFGraphics(resultPdf, pageFormat);
                int result = printable.print(resultPdf, pageFormat, i);
                this.endPagePDFGraphics(resultPdf);
                return result;
            }
            return 1;
        }
        return printable.print(dummyG, pageFormat, i);
    }

    private Graphics2D createPDFGraphics(OutputStream out, PageFormat format) {
        UserProperties props = this.createPdfProperties(format);
        WebPdfGraphics2D graphics = new WebPdfGraphics2D(out, this.getPageDimension(props));
        graphics.setProperties((Properties)props);
        graphics.setMultiPage(true);
        graphics.startExport();
        return graphics;
    }

    private void startPagePDFGraphics(Graphics2D pdfGrapthics, PageFormat format) {
        try {
            PDFGraphics2D g = (PDFGraphics2D)pdfGrapthics;
            UserProperties props = this.createPdfProperties(format);
            g.setProperties((Properties)props);
            g.openPage(this.getPageDimension(props), null);
            g.clipRect(format.getImageableX(), format.getImageableY(), format.getImageableWidth(), format.getImageableHeight());
        }
        catch (IOException e) {
            ((PDFGraphics2D)pdfGrapthics).endExport();
            throw new RuntimeException(e);
        }
    }

    private void endPagePDFGraphics(Graphics2D pdfGrapthics) {
        try {
            ((PDFGraphics2D)pdfGrapthics).setTransform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
            ((PDFGraphics2D)pdfGrapthics).closePage();
        }
        catch (IOException e) {
            ((PDFGraphics2D)pdfGrapthics).endExport();
            throw new RuntimeException(e);
        }
    }

    private void closePDFGraphics(Graphics2D pdfGrapthics) {
        ((PDFGraphics2D)pdfGrapthics).endExport();
    }

    private Dimension getPageDimension(UserProperties props) {
        Dimension d = PageConstants.getSize((String)props.getProperty(PDFGraphics2D.PAGE_SIZE), (String)props.getProperty(PDFGraphics2D.ORIENTATION));
        Insets m = PageConstants.getMargins((Insets)props.getPropertyInsets(PDFGraphics2D.PAGE_MARGINS), (String)props.getProperty(PDFGraphics2D.ORIENTATION));
        Dimension result = new Dimension();
        result.setSize(d.getWidth() - (double)m.left - (double)m.right, d.getHeight() - (double)m.top - (double)m.bottom);
        return result;
    }

    private UserProperties createPdfProperties(PageFormat format) {
        UserProperties props = new UserProperties();
        String orientation = format.getOrientation() == 0 ? "Landscape" : "Portrait";
        String size = this.resolveSize(format);
        props.setProperty(PDFGraphics2D.ORIENTATION, orientation);
        props.setProperty(PDFGraphics2D.PAGE_SIZE, size);
        props.setProperty(PDFGraphics2D.FIT_TO_PAGE, false);
        props.setProperty(PDFGraphics2D.PAGE_MARGINS, "0, 0, 0, 0");
        props.setProperty(PDFGraphics2D.AUTHOR, "Webswing.org");
        props.setProperty(PDFGraphics2D.KEYWORDS, "Page:" + size + " Orientation:" + orientation);
        return props;
    }

    private String resolveSize(PageFormat format) {
        Paper p = format.getPaper();
        MediaSizeName size = WebPrinterJobWrapper.findMedia((double)p.getWidth(), (double)p.getHeight());
        if (size == MediaSizeName.ISO_A3) {
            return "A3";
        }
        if (size == MediaSizeName.ISO_A4) {
            return "A4";
        }
        if (size == MediaSizeName.ISO_A5) {
            return "A5";
        }
        if (size == MediaSizeName.ISO_A6) {
            return "A6";
        }
        if (size == MediaSizeName.NA_LETTER) {
            return "Letter";
        }
        if (size == MediaSizeName.NA_LEGAL) {
            return "Legal";
        }
        if (size == MediaSizeName.EXECUTIVE) {
            return "Executive";
        }
        if (size == MediaSizeName.LEDGER) {
            return "Ledger";
        }
        return "A4";
    }

    private boolean isInRange(int i, PrintRequestAttributeSet attribs) {
        PageRanges range = null;
        range = (PageRanges)attribs.get(PageRanges.class);
        if (range != null) {
            return range.contains(i + 1);
        }
        return true;
    }

    static {
        dummyG = new DummyGraphics2D();
    }

    public static class WebPdfGraphics2D
    extends PDFGraphics2D {
        public WebPdfGraphics2D(File file, Dimension size) throws FileNotFoundException {
            super(file, size);
        }

        public WebPdfGraphics2D(File file, Component component) throws FileNotFoundException {
            super(file, component);
        }

        public WebPdfGraphics2D(OutputStream ros, Dimension size) {
            super(ros, size);
        }

        public WebPdfGraphics2D(OutputStream ros, Component component) {
            super(ros, component);
        }

        protected WebPdfGraphics2D(WebPdfGraphics2D graphics, boolean doRestoreOnDispose) {
            super((PDFGraphics2D)graphics, doRestoreOnDispose);
        }

        public GraphicsConfiguration getDeviceConfiguration() {
            return Util.getWebToolkit().getGraphicsConfig();
        }

        public Graphics create() {
            try {
                this.writeGraphicsSave();
            }
            catch (IOException e) {
                this.handleException(e);
            }
            return new WebPdfGraphics2D(this, true);
        }

        public Graphics create(double x, double y, double width, double height) {
            try {
                this.writeGraphicsSave();
            }
            catch (IOException e) {
                this.handleException(e);
            }
            WebPdfGraphics2D graphics = new WebPdfGraphics2D(this, true);
            graphics.translate(x, y);
            graphics.clipRect(0.0, 0.0, width, height);
            return graphics;
        }
    }
}

